/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.core;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.util.chat.filters.LinkDetector;
import com.nonxedy.nonchat.util.core.broadcast.BroadcastMessage;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class BroadcastManager {
    private final Nonchat plugin;
    private final PluginConfig config;
    private final Map<String, BukkitTask> activeTasks;
    private final List<BroadcastMessage> randomMessagePool;
    private BukkitTask randomBroadcastTask;

    public BroadcastManager(Nonchat plugin, PluginConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.activeTasks = new HashMap<String, BukkitTask>();
        this.randomMessagePool = new ArrayList<BroadcastMessage>();
        this.start();
    }

    public void start() {
        this.stop();
        Map<String, BroadcastMessage> configuredMessages = this.config.getBroadcastMessages();
        configuredMessages.forEach((key, message) -> {
            if (!message.isEnabled()) {
                return;
            }
            if (this.config.isRandomBroadcastEnabled()) {
                this.randomMessagePool.add((BroadcastMessage)message);
            } else {
                this.scheduleRegularBroadcast((String)key, (BroadcastMessage)message);
            }
        });
        if (this.config.isRandomBroadcastEnabled() && !this.randomMessagePool.isEmpty()) {
            this.startRandomBroadcasts();
        }
    }

    public void broadcast(CommandSender sender, String message) {
        try {
            Component formatted = LinkDetector.makeLinksClickable(message);
            Bukkit.broadcast((Component)formatted);
        }
        catch (NoSuchMethodError e) {
            this.plugin.logError("Adventure API isn't avaible: " + e.getMessage());
            String legacyMessage = ColorUtil.parseColor(message);
            Bukkit.broadcastMessage((String)legacyMessage);
        }
    }

    private void scheduleRegularBroadcast(String key, BroadcastMessage message) {
        BukkitTask task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.broadcast((CommandSender)Bukkit.getConsoleSender(), message.getMessage()), 0L, (long)message.getInterval() * 20L);
        this.activeTasks.put(key, task);
    }

    private void startRandomBroadcasts() {
        this.randomBroadcastTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            if (this.randomMessagePool.isEmpty()) {
                return;
            }
            int randomIndex = new Random().nextInt(this.randomMessagePool.size());
            BroadcastMessage message = this.randomMessagePool.get(randomIndex);
            this.broadcast((CommandSender)Bukkit.getConsoleSender(), message.getMessage());
        }, 0L, (long)this.config.getBroadcastInterval() * 20L);
    }

    public void stop() {
        this.activeTasks.values().forEach(BukkitTask::cancel);
        this.activeTasks.clear();
        if (this.randomBroadcastTask != null) {
            this.randomBroadcastTask.cancel();
            this.randomBroadcastTask = null;
        }
    }

    public void reload() {
        this.stop();
        this.start();
    }
}

