/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.core;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.api.Channel;
import com.nonxedy.nonchat.api.ChannelAPI;
import com.nonxedy.nonchat.chat.channel.ChannelManager;
import com.nonxedy.nonchat.command.impl.IgnoreCommand;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.util.chat.filters.AdDetector;
import com.nonxedy.nonchat.util.chat.filters.CapsFilter;
import com.nonxedy.nonchat.util.chat.filters.WordBlocker;
import com.nonxedy.nonchat.util.chat.packets.BubblePacketUtil;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ChatManager {
    private final Nonchat plugin;
    private final PluginConfig config;
    private final PluginMessages messages;
    private final ChannelManager channelManager;
    private final Pattern mentionPattern = Pattern.compile("@(\\w+)");
    private final Map<Player, List<ArmorStand>> bubbles = new ConcurrentHashMap<Player, List<ArmorStand>>();
    private final Map<Player, ReentrantLock> playerLocks = new ConcurrentHashMap<Player, ReentrantLock>();
    private IgnoreCommand ignoreCommand;
    private final AdDetector adDetector;

    public ChatManager(Nonchat plugin, PluginConfig config, PluginMessages messages) {
        this.plugin = plugin;
        this.config = config;
        this.messages = messages;
        this.channelManager = new ChannelManager(config);
        this.ignoreCommand = plugin.getIgnoreCommand();
        this.adDetector = new AdDetector(config, config.getAntiAdSensitivity(), config.getAntiAdPunishCommand());
        this.startBubbleUpdater();
    }

    private Logger getLogger() {
        return this.plugin.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChat(Player player, String messageContent) {
        ReentrantLock lock = this.playerLocks.computeIfAbsent(player, p -> new ReentrantLock());
        lock.lock();
        try {
            boolean shouldShowBubble;
            String messageForLengthCheck;
            String finalMessage;
            Channel channel;
            if (messageContent == null || messageContent.trim().isEmpty()) {
                return;
            }
            if (this.handleBlockedWords(player, messageContent)) {
                return;
            }
            CapsFilter capsFilter = this.config.getCapsFilter();
            if (!player.hasPermission("nonchat.caps.bypass") && capsFilter.shouldFilter(messageContent)) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("caps-filter").replace("{percentage}", String.valueOf(capsFilter.getMaxCapsPercentage()))));
                return;
            }
            if (this.config.isAntiAdEnabled() && !player.hasPermission("nonchat.ad.bypass") && this.adDetector.shouldFilter(player, messageContent)) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("blocked-words")));
                return;
            }
            if (!player.hasPermission("nonchat.color") && ColorUtil.hasColorCodes(messageContent) && (messageContent = ColorUtil.stripAllColors(messageContent)).trim().isEmpty()) {
                return;
            }
            if (messageContent.length() > 0) {
                char firstChar = messageContent.charAt(0);
                channel = this.findChannelByChar(firstChar);
                if (channel != null) {
                    finalMessage = messageContent.substring(1);
                    if (finalMessage.trim().isEmpty()) {
                        return;
                    }
                } else {
                    channel = this.channelManager.getPlayerChannel(player);
                    finalMessage = messageContent;
                }
            } else {
                channel = this.channelManager.getPlayerChannel(player);
                finalMessage = messageContent;
            }
            if (!channel.isEnabled()) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("chat-disabled")));
                return;
            }
            if (!channel.canSend(player)) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
                return;
            }
            String string = messageForLengthCheck = player.hasPermission("nonchat.color") ? finalMessage : ColorUtil.stripAllColors(finalMessage);
            if (messageForLengthCheck.length() < channel.getMinLength()) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("message-too-short").replace("{min}", String.valueOf(channel.getMinLength()))));
                return;
            }
            if (channel.getMaxLength() > 0 && messageForLengthCheck.length() > channel.getMaxLength()) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("message-too-long").replace("{max}", String.valueOf(channel.getMaxLength()))));
                return;
            }
            if (!this.channelManager.canSendMessage(player, channel)) {
                int remainingSeconds = this.channelManager.getRemainingCooldown(player, channel);
                player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-cooldown").replace("{seconds}", String.valueOf(remainingSeconds)).replace("{channel}", channel.getDisplayName())));
                return;
            }
            this.channelManager.recordMessageSent(player);
            if (ChannelAPI.shouldFilterMessage(player, finalMessage, channel.getId())) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("message-filtered")));
                return;
            }
            String processedMessage = ChannelAPI.processMessage(player, finalMessage, channel.getId());
            if (processedMessage == null) {
                return;
            }
            String messageToSend = processedMessage;
            boolean bl = shouldShowBubble = this.config.isChatBubblesEnabled() && player.hasPermission("nonchat.chatbubbles") && this.isPublicChannel(channel);
            if (shouldShowBubble) {
                try {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        try {
                            this.removeBubble(player);
                            String bubbleMessage = player.hasPermission("nonchat.color") ? messageToSend : ColorUtil.stripAllColors(messageToSend);
                            this.createBubble(player, bubbleMessage);
                        }
                        catch (Exception e) {
                            this.getLogger().warning("Error in bubble creation task for player " + player.getName() + ": " + e.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    this.getLogger().warning("Failed to schedule bubble creation for player " + player.getName() + ": " + e.getMessage());
                    try {
                        this.removeBubble(player);
                        String bubbleMessage = player.hasPermission("nonchat.color") ? messageToSend : ColorUtil.stripAllColors(messageToSend);
                        this.createBubble(player, bubbleMessage);
                    }
                    catch (Exception fallbackError) {
                        this.getLogger().warning("Fallback bubble creation also failed for player " + player.getName() + ": " + fallbackError.getMessage());
                        try {
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                                try {
                                    this.removeBubble(player);
                                    String bubbleMessage = player.hasPermission("nonchat.color") ? messageToSend : ColorUtil.stripAllColors(messageToSend);
                                    this.createBubble(player, bubbleMessage);
                                }
                                catch (Exception globalError) {
                                    this.getLogger().warning("Global scheduler bubble creation also failed for player " + player.getName() + ": " + globalError.getMessage());
                                }
                            });
                        }
                        catch (Exception globalSchedulerError) {
                            this.getLogger().warning("Failed to schedule global bubble creation for player " + player.getName() + ": " + globalSchedulerError.getMessage());
                        }
                    }
                }
            }
            this.handleMentions(player, messageToSend);
            Component formattedMessage = channel.formatMessage(player, messageToSend);
            boolean messageDelivered = this.broadcastMessage(player, formattedMessage, channel, messageToSend);
            if (this.config.isUndeliveredMessageNotificationEnabled() && !messageDelivered) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("message-not-delivered")));
            }
        }
        finally {
            lock.unlock();
            if (!player.isOnline()) {
                this.playerLocks.remove(player);
            }
        }
    }

    private boolean isPublicChannel(Channel channel) {
        if (this.config.shouldShowBubblesInPrivateChannels()) {
            return true;
        }
        String receivePermission = channel.getReceivePermission();
        if (receivePermission != null && !receivePermission.isEmpty()) {
            return false;
        }
        String sendPermission = channel.getSendPermission();
        return sendPermission == null || sendPermission.isEmpty();
    }

    private void startBubbleUpdater() {
        try {
            Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
                try {
                    this.bubbles.entrySet().stream().filter(entry -> ((Player)entry.getKey()).isOnline() && !((List)entry.getValue()).isEmpty()).forEach(entry -> {
                        try {
                            Player player = (Player)entry.getKey();
                            Location newLoc = player.getLocation().add(0.0, this.config.getChatBubblesHeight(), 0.0);
                            BubblePacketUtil.updateBubblesLocation((List)entry.getValue(), newLoc);
                        }
                        catch (Exception e) {
                            this.getLogger().fine("Error updating bubbles for player " + ((Player)entry.getKey()).getName() + ": " + e.getMessage());
                        }
                    });
                    this.bubbles.entrySet().removeIf(entry -> {
                        try {
                            if (!((Player)entry.getKey()).isOnline()) {
                                BubblePacketUtil.removeBubbles((List)entry.getValue());
                                return true;
                            }
                        }
                        catch (Exception e) {
                            this.getLogger().fine("Error cleaning up bubbles for offline player: " + e.getMessage());
                            return true;
                        }
                        return false;
                    });
                }
                catch (Exception e) {
                    this.getLogger().warning("Error in bubble updater: " + e.getMessage());
                }
            }, 1L, 1L);
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to start bubble updater: " + e.getMessage());
            try {
                Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
                    try {
                        this.bubbles.entrySet().stream().filter(entry -> ((Player)entry.getKey()).isOnline() && !((List)entry.getValue()).isEmpty()).forEach(entry -> {
                            try {
                                Player player = (Player)entry.getKey();
                                Location newLoc = player.getLocation().add(0.0, this.config.getChatBubblesHeight(), 0.0);
                                BubblePacketUtil.updateBubblesLocation((List)entry.getValue(), newLoc);
                            }
                            catch (Exception e2) {
                                this.getLogger().fine("Error updating bubbles for player " + ((Player)entry.getKey()).getName() + ": " + e2.getMessage());
                            }
                        });
                        this.bubbles.entrySet().removeIf(entry -> {
                            try {
                                if (!((Player)entry.getKey()).isOnline()) {
                                    BubblePacketUtil.removeBubbles((List)entry.getValue());
                                    return true;
                                }
                            }
                            catch (Exception e2) {
                                this.getLogger().fine("Error cleaning up bubbles for offline player: " + e2.getMessage());
                                return true;
                            }
                            return false;
                        });
                    }
                    catch (Exception e2) {
                        this.getLogger().warning("Error in fallback bubble updater: " + e2.getMessage());
                    }
                }, 1L, 1L);
                this.getLogger().info("Bubble updater started with fallback scheduler");
            }
            catch (Exception fallbackError) {
                this.getLogger().severe("Failed to start bubble updater with fallback scheduler: " + fallbackError.getMessage());
                try {
                    this.getLogger().info("Starting bubble updater with immediate execution as last resort");
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        try {
                            this.bubbles.entrySet().stream().filter(entry -> ((Player)entry.getKey()).isOnline() && !((List)entry.getValue()).isEmpty()).forEach(entry -> {
                                try {
                                    Player player = (Player)entry.getKey();
                                    Location newLoc = player.getLocation().add(0.0, this.config.getChatBubblesHeight(), 0.0);
                                    BubblePacketUtil.updateBubblesLocation((List)entry.getValue(), newLoc);
                                }
                                catch (Exception e2) {
                                    this.getLogger().fine("Error updating bubbles for player " + ((Player)entry.getKey()).getName() + ": " + e2.getMessage());
                                }
                            });
                            this.bubbles.entrySet().removeIf(entry -> {
                                try {
                                    if (!((Player)entry.getKey()).isOnline()) {
                                        BubblePacketUtil.removeBubbles((List)entry.getValue());
                                        return true;
                                    }
                                }
                                catch (Exception e2) {
                                    this.getLogger().fine("Error cleaning up bubbles for offline player: " + e2.getMessage());
                                    return true;
                                }
                                return false;
                            });
                        }
                        catch (Exception e2) {
                            this.getLogger().warning("Error in immediate bubble updater: " + e2.getMessage());
                        }
                    });
                    this.getLogger().info("Bubble updater started with immediate execution");
                }
                catch (Exception immediateError) {
                    this.getLogger().severe("Failed to start bubble updater with immediate execution: " + immediateError.getMessage());
                }
            }
        }
    }

    private void createBubble(Player player, String message) {
        block10: {
            if (player.getGameMode() == GameMode.SPECTATOR) {
                return;
            }
            try {
                Location loc = player.getLocation().add(0.0, this.config.getChatBubblesHeight(), 0.0);
                List<ArmorStand> playerBubbles = BubblePacketUtil.spawnMultilineBubble(player, message, loc);
                if (playerBubbles != null && !playerBubbles.isEmpty()) {
                    this.bubbles.put(player, playerBubbles);
                    try {
                        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.removeBubble(player), (long)this.config.getChatBubblesDuration() * 20L);
                    }
                    catch (Exception e) {
                        this.getLogger().warning("Failed to schedule bubble removal for player " + player.getName() + ": " + e.getMessage());
                        try {
                            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.removeBubble(player), (long)this.config.getChatBubblesDuration() * 20L);
                            break block10;
                        }
                        catch (Exception fallbackError) {
                            this.getLogger().warning("Fallback bubble removal scheduling also failed for player " + player.getName() + ": " + fallbackError.getMessage());
                            try {
                                this.removeBubble(player);
                                break block10;
                            }
                            catch (Exception immediateError) {
                                this.getLogger().warning("Immediate bubble removal also failed for player " + player.getName() + ": " + immediateError.getMessage());
                            }
                        }
                    }
                    break block10;
                }
                this.getLogger().warning("Failed to create chat bubbles for player: " + player.getName());
            }
            catch (Exception e) {
                this.getLogger().warning("Error creating chat bubbles for player " + player.getName() + ": " + e.getMessage());
            }
        }
    }

    private void removeBubble(Player player) {
        try {
            List<ArmorStand> playerBubbles = this.bubbles.remove(player);
            if (playerBubbles != null) {
                BubblePacketUtil.removeBubbles(playerBubbles);
            }
        }
        catch (Exception e) {
            this.getLogger().fine("Error removing bubbles for player " + player.getName() + ": " + e.getMessage());
            try {
                this.bubbles.remove(player);
            }
            catch (Exception cleanupError) {
                this.getLogger().fine("Error cleaning up bubble map for player " + player.getName() + ": " + cleanupError.getMessage());
            }
        }
    }

    private boolean handleBlockedWords(Player player, String message) {
        String messageToCheck;
        WordBlocker wordBlocker;
        if (!player.hasPermission("nonchat.antiblockedwords") && !(wordBlocker = this.config.getWordBlocker()).isMessageAllowed(messageToCheck = ColorUtil.stripAllColors(message))) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("blocked-words")));
            return true;
        }
        return false;
    }

    private void handleMentions(Player sender, String message) {
        String messageToCheck = ColorUtil.stripAllColors(message);
        Matcher mentionMatcher = this.mentionPattern.matcher(messageToCheck);
        ArrayList<String> mentionedNames = new ArrayList<String>();
        while (mentionMatcher.find()) {
            mentionedNames.add(mentionMatcher.group(1));
        }
        mentionedNames.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).filter(OfflinePlayer::isOnline).forEach(player -> this.notifyMentionedPlayer((Player)player, sender));
    }

    private void notifyMentionedPlayer(Player mentioned, Player sender) {
        String mentionMessage = this.messages.getString("mentioned");
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                mentionMessage = PlaceholderAPI.setPlaceholders((Player)sender, (String)mentionMessage);
            }
            catch (Exception e) {
                this.plugin.logError("Error processing mention message placeholders: " + e.getMessage());
            }
        }
        mentionMessage = mentionMessage.replace("{player}", sender.getName());
        mentioned.sendMessage(ColorUtil.parseComponent(mentionMessage));
        mentioned.playSound(mentioned.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
    }

    private boolean broadcastMessage(Player sender, Component message, Channel channel, String originalMessage) {
        String consoleFormat = channel.getFormat().replace("{message}", originalMessage);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                consoleFormat = PlaceholderAPI.setPlaceholders((Player)sender, (String)consoleFormat);
            }
            catch (Exception e) {
                this.plugin.logError("Error processing format placeholders for console: " + e.getMessage());
            }
        }
        Bukkit.getConsoleSender().sendMessage(ColorUtil.parseComponent(consoleFormat));
        long recipientCount = Bukkit.getOnlinePlayers().stream().filter(recipient -> this.ignoreCommand == null || !this.ignoreCommand.isIgnoring((Player)recipient, sender)).filter(recipient -> channel.canReceive((Player)recipient)).filter(recipient -> channel.isGlobal() || channel.isInRange(sender, (Player)recipient)).peek(recipient -> recipient.sendMessage(message)).count();
        return recipientCount > 1L;
    }

    private Channel findChannelByChar(char c) {
        return this.channelManager.findChannelByCharacter(c).orElse(null);
    }

    public boolean setPlayerChannel(Player player, String channelId) {
        return this.channelManager.setPlayerChannel(player, channelId);
    }

    public Channel getPlayerChannel(Player player) {
        return this.channelManager.getPlayerChannel(player);
    }

    public Channel getChannel(String id) {
        return this.channelManager.getChannel(id);
    }

    public Collection<Channel> getAllChannels() {
        return this.channelManager.getAllChannels();
    }

    public Collection<Channel> getEnabledChannels() {
        return this.channelManager.getEnabledChannels();
    }

    public void reloadChannels() {
        this.channelManager.loadChannels();
    }

    public Channel createChannel(String channelId, String displayName, String format, Character character, String sendPermission, String receivePermission, int radius, int cooldown, int minLength, int maxLength) {
        return this.channelManager.createChannel(channelId, displayName, format, character, sendPermission, receivePermission, radius, cooldown, minLength, maxLength);
    }

    public boolean updateChannel(String channelId, String displayName, String format, Character character, String sendPermission, String receivePermission, Integer radius, Boolean enabled, Integer cooldown, Integer minLength, Integer maxLength) {
        return this.channelManager.updateChannel(channelId, displayName, format, character, sendPermission, receivePermission, radius, enabled, cooldown, minLength, maxLength);
    }

    public boolean deleteChannel(String channelId) {
        return this.channelManager.deleteChannel(channelId);
    }

    public boolean setDefaultChannel(String channelId) {
        return this.channelManager.setDefaultChannel(channelId);
    }

    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    public void setIgnoreCommand(IgnoreCommand ignoreCommand) {
        this.ignoreCommand = ignoreCommand;
    }

    public void cleanup() {
        this.bubbles.values().forEach(BubblePacketUtil::removeBubbles);
        this.bubbles.clear();
        this.playerLocks.clear();
    }
}

