/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.core;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.command.impl.IgnoreCommand;
import com.nonxedy.nonchat.command.impl.SpyCommand;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import com.nonxedy.nonchat.util.integration.external.IntegrationUtil;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class MessageManager {
    private final Nonchat plugin;
    private final PluginConfig config;
    private final PluginMessages messages;
    private final SpyCommand spyCommand;
    private final Map<UUID, UUID> lastMessageSender = new ConcurrentHashMap<UUID, UUID>();
    private volatile IgnoreCommand ignoreCommand;

    public MessageManager(Nonchat plugin, PluginConfig config, PluginMessages messages, SpyCommand spyCommand) {
        this.plugin = plugin;
        this.config = config;
        this.messages = messages;
        this.spyCommand = spyCommand;
    }

    public Map<UUID, UUID> getLastMessageSender() {
        return this.lastMessageSender;
    }

    public void sendPrivateMessage(Player sender, Player receiver, String message) {
        if (this.ignoreCommand != null && this.ignoreCommand.isIgnoring(receiver, sender)) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("ignored-by-target")));
            return;
        }
        if (this.ignoreCommand != null && this.ignoreCommand.isIgnoring(sender, receiver)) {
            sender.sendMessage(ColorUtil.parseComponent(this.messages.getString("you-are-ignoring-player").replace("%player%", receiver.getName())));
            return;
        }
        if (receiver == null || !receiver.isOnline()) {
            if (this.config.isUndeliveredMessageNotificationEnabled()) {
                sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("message-not-delivered")));
            }
            return;
        }
        this.lastMessageSender.put(receiver.getUniqueId(), sender.getUniqueId());
        String processedMessage = sender.hasPermission("nonchat.color") ? message : ColorUtil.stripAllColors(message);
        String senderFormat = this.config.getPrivateChatFormat().replace("{sender}", sender.getName()).replace("{target}", receiver.getName()).replace("{message}", processedMessage);
        String targetYouText = this.config.getPrivateChatTargetYou();
        targetYouText = IntegrationUtil.processPlaceholders(receiver, targetYouText);
        String receiverFormat = this.config.getPrivateChatFormat().replace("{sender}", sender.getName()).replace("{target}", targetYouText).replace("{message}", processedMessage);
        sender.sendMessage(ColorUtil.parseComponent(senderFormat));
        receiver.sendMessage(ColorUtil.parseComponent(receiverFormat));
        this.spyCommand.onPrivateMessage(sender, receiver, (Component)Component.text((String)processedMessage));
    }

    public void replyToLastMessage(Player sender, String message) {
        UUID lastSenderUUID = this.getLastMessageSender().get(sender.getUniqueId());
        if (lastSenderUUID == null) {
            this.plugin.logError("No last message sender found for player " + sender.getName());
            sender.sendMessage(ColorUtil.parseComponent(this.messages.getString("no-reply-target")));
            return;
        }
        Player receiver = Bukkit.getPlayer((UUID)lastSenderUUID);
        if (receiver == null || !receiver.isOnline()) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("player-offline")));
            return;
        }
        this.sendPrivateMessage(sender, receiver, message);
    }

    public Player getLastMessageSender(Player player) {
        UUID lastSenderUUID = this.lastMessageSender.get(player.getUniqueId());
        return lastSenderUUID != null ? Bukkit.getPlayer((UUID)lastSenderUUID) : null;
    }

    public void clearLastMessageSender(Player player) {
        this.lastMessageSender.remove(player.getUniqueId());
    }

    public void setIgnoreCommand(IgnoreCommand ignoreCommand) {
        this.ignoreCommand = ignoreCommand;
    }
}

