/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.service;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.command.impl.BroadcastCommand;
import com.nonxedy.nonchat.command.impl.ChannelCommand;
import com.nonxedy.nonchat.command.impl.ClearCommand;
import com.nonxedy.nonchat.command.impl.IgnoreCommand;
import com.nonxedy.nonchat.command.impl.MeCommand;
import com.nonxedy.nonchat.command.impl.MessageCommand;
import com.nonxedy.nonchat.command.impl.NonchatCommand;
import com.nonxedy.nonchat.command.impl.ReplyCommand;
import com.nonxedy.nonchat.command.impl.RollCommand;
import com.nonxedy.nonchat.command.impl.SpyCommand;
import com.nonxedy.nonchat.service.ChatService;
import com.nonxedy.nonchat.service.ConfigService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;

public class CommandService {
    private final Nonchat plugin;
    private final ChatService chatService;
    private final ConfigService configService;
    private final Map<String, CommandExecutor> commands;

    public CommandService(Nonchat plugin, ChatService chatService, ConfigService configService) {
        this.plugin = plugin;
        this.chatService = chatService;
        this.configService = configService;
        this.commands = new HashMap<String, CommandExecutor>();
        this.registerCommands();
    }

    private void registerCommands() {
        this.plugin.logResponse("Registering commands...");
        SpyCommand spyCommand = this.plugin.getSpyCommand();
        IgnoreCommand ignoreCommand = this.plugin.getIgnoreCommand();
        MessageCommand messageCommand = new MessageCommand(this.plugin, this.configService.getConfig(), this.configService.getMessages(), spyCommand);
        this.registerCommand("msg", messageCommand);
        this.registerCommand("tell", messageCommand);
        this.registerCommand("w", messageCommand);
        this.registerCommand("message", messageCommand);
        this.registerCommand("reply", new ReplyCommand(this.plugin, this.plugin.getMessageManager(), this.configService.getMessages()));
        this.registerCommand("r", new ReplyCommand(this.plugin, this.plugin.getMessageManager(), this.configService.getMessages()));
        this.registerCommand("broadcast", new BroadcastCommand(this.configService.getMessages(), this.plugin, this.configService.getConfig()));
        this.registerCommand("spy", spyCommand);
        this.registerCommand("clear", new ClearCommand(this.configService.getMessages(), this.plugin));
        this.registerCommand("ignore", ignoreCommand);
        this.registerCommand("channel", new ChannelCommand(this.plugin, this.plugin.getChatManager(), this.configService.getMessages()));
        this.registerCommand("me", new MeCommand(this.plugin, this.configService.getConfig(), this.configService.getMessages()));
        this.registerCommand("roll", new RollCommand(this.plugin, this.configService.getConfig(), this.configService.getMessages()));
        this.registerCommand("nonchat", new NonchatCommand(this.plugin, this.configService));
        this.plugin.logResponse("Registered " + this.commands.size() + " traditional commands");
    }

    public void registerCommand(String name, CommandExecutor executor) {
        this.commands.put(name.toLowerCase(), executor);
        PluginCommand pluginCommand = this.plugin.getCommand(name);
        if (pluginCommand != null) {
            pluginCommand.setExecutor(executor);
            if (executor instanceof TabCompleter) {
                TabCompleter tabCompleter = (TabCompleter)executor;
                pluginCommand.setTabCompleter(tabCompleter);
            }
            this.plugin.logResponse("Registered traditional command: " + name);
        } else {
            this.plugin.logError("Command '" + name + "' not found in plugin.yml");
        }
    }

    public CommandExecutor getCommand(String name) {
        return this.commands.get(name.toLowerCase());
    }

    public void reloadCommands() {
        this.plugin.logResponse("Reloading commands...");
        this.registerCommands();
        this.plugin.logResponse("Commands reloaded successfully");
    }

    public Set<String> getRegisteredCommands() {
        return Collections.unmodifiableSet(this.commands.keySet());
    }

    public void unregisterAll() {
        this.commands.forEach((name, executor) -> {
            PluginCommand pluginCommand = this.plugin.getCommand((String)name);
            if (pluginCommand != null) {
                pluginCommand.setExecutor(null);
                pluginCommand.setTabCompleter(null);
            }
        });
        this.commands.clear();
    }
}

