/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.chat.packets;

import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;

public class BubblePacketUtil {
    private static final int MAX_LINE_LENGTH = 40;
    private static final double LINE_SPACING = 0.25;
    private static final ObjectPool<ArmorStand> armorStandPool = new ObjectPool(50);

    public static List<ArmorStand> spawnMultilineBubble(Player player, String text, Location location) {
        List<String> lines = BubblePacketUtil.splitTextIntoLines(text, 40);
        ArrayList<ArmorStand> bubbleStands = new ArrayList<ArmorStand>();
        for (int i = 0; i < lines.size(); ++i) {
            Location lineLocation = location.clone().add(0.0, (double)(lines.size() - 1 - i) * 0.25, 0.0);
            ArmorStand bubble = armorStandPool.acquire(() -> {
                try {
                    World world = player.getWorld();
                    ArmorStand as = (ArmorStand)world.spawnEntity(lineLocation, EntityType.ARMOR_STAND);
                    BubblePacketUtil.configureArmorStand(as);
                    return as;
                }
                catch (Exception e) {
                    Bukkit.getLogger().warning("[nonchat] Failed to spawn armor stand: " + e.getMessage());
                    return null;
                }
            });
            if (bubble == null) continue;
            try {
                bubble.teleport(lineLocation);
                Component component = ColorUtil.parseComponent(lines.get(i));
                bubble.customName(component);
                bubbleStands.add(bubble);
                continue;
            }
            catch (Exception e) {
                if (bubble != null && !bubble.isDead()) {
                    bubble.remove();
                }
                Bukkit.getLogger().warning("[nonchat] Failed to configure armor stand: " + e.getMessage());
            }
        }
        return bubbleStands;
    }

    private static void configureArmorStand(ArmorStand as) {
        try {
            as.setCustomNameVisible(true);
            as.setInvisible(true);
            as.setGravity(false);
            as.setMarker(true);
            as.setSmall(true);
            as.getEquipment().clear();
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                as.setDisabledSlots(new EquipmentSlot[]{slot});
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().fine("[nonchat] Error configuring armor stand: " + e.getMessage());
        }
    }

    public static ArmorStand spawnBubble(Player player, String text, Location location) {
        ArmorStand bubble = armorStandPool.acquire(() -> {
            try {
                World world = player.getWorld();
                ArmorStand as = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
                BubblePacketUtil.configureArmorStand(as);
                return as;
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("[nonchat] Failed to spawn armor stand: " + e.getMessage());
                return null;
            }
        });
        if (bubble == null) {
            return null;
        }
        try {
            Component component = ColorUtil.parseComponent(text);
            bubble.customName(component);
            bubble.teleport(location);
        }
        catch (Exception e) {
            if (bubble != null && !bubble.isDead()) {
                bubble.remove();
            }
            Bukkit.getLogger().warning("[nonchat] Failed to configure armor stand: " + e.getMessage());
            return null;
        }
        return bubble;
    }

    public static void removeBubble(ArmorStand bubble) {
        try {
            if (bubble != null && !bubble.isDead()) {
                bubble.remove();
                armorStandPool.release(bubble);
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().fine("[nonchat] Error removing bubble: " + e.getMessage());
        }
    }

    public static void removeBubbles(List<ArmorStand> bubbles) {
        try {
            if (bubbles != null) {
                bubbles.forEach(BubblePacketUtil::removeBubble);
                bubbles.clear();
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().fine("[nonchat] Error removing bubbles: " + e.getMessage());
        }
    }

    public static void updateBubbleLocation(ArmorStand bubble, Location location) {
        try {
            if (bubble != null && !bubble.isDead()) {
                bubble.teleport(location);
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().fine("[nonchat] Error updating bubble location: " + e.getMessage());
        }
    }

    public static void updateBubblesLocation(List<ArmorStand> bubbles, Location baseLocation) {
        try {
            if (bubbles != null) {
                bubbles.removeIf(bubble -> bubble == null || bubble.isDead());
                for (int i = 0; i < bubbles.size(); ++i) {
                    try {
                        ArmorStand bubble2 = bubbles.get(i);
                        if (bubble2 == null || bubble2.isDead()) continue;
                        Location lineLocation = baseLocation.clone().add(0.0, (double)(bubbles.size() - 1 - i) * 0.25, 0.0);
                        bubble2.teleport(lineLocation);
                        continue;
                    }
                    catch (Exception e) {
                        Bukkit.getLogger().fine("[nonchat] Error updating bubble " + i + " location: " + e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().fine("[nonchat] Error updating bubbles location: " + e.getMessage());
        }
    }

    private static List<String> splitTextIntoLines(String text, int maxLength) {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            Pattern colorPattern = Pattern.compile("\u00a7[0-9a-fk-or]|&#[0-9a-fA-F]{6}");
            String currentColor = "";
            String processedText = ColorUtil.parseColor(text);
            String[] words = processedText.split(" ");
            StringBuilder currentLine = new StringBuilder();
            for (String word : words) {
                String lineWithoutColors;
                int currentVisibleLength;
                String wordWithoutColors = word.replaceAll("\u00a7[0-9a-fk-or]|&#[0-9a-fA-F]{6}", "");
                int visibleLength = wordWithoutColors.length();
                if (currentVisibleLength + visibleLength + ((currentVisibleLength = (lineWithoutColors = currentLine.toString().replaceAll("\u00a7[0-9a-fk-or]|&#[0-9a-fA-F]{6}", "")).length()) > 0 ? 1 : 0) <= maxLength) {
                    if (currentLine.length() > 0) {
                        currentLine.append(" ");
                    }
                    currentLine.append(word);
                    continue;
                }
                if (currentLine.length() > 0) {
                    lines.add(currentLine.toString());
                    Matcher matcher = colorPattern.matcher(currentLine.toString());
                    currentColor = "";
                    while (matcher.find()) {
                        currentColor = matcher.group();
                    }
                    currentLine = new StringBuilder(currentColor);
                }
                if (visibleLength > maxLength) {
                    StringBuilder remainingWord = new StringBuilder(word);
                    while (remainingWord.length() > 0) {
                        StringBuilder colorCodes = new StringBuilder();
                        int i = 0;
                        while (i < remainingWord.length()) {
                            if (remainingWord.charAt(i) == '\u00a7' && i + 1 < remainingWord.length()) {
                                colorCodes.append(remainingWord.charAt(i)).append(remainingWord.charAt(i + 1));
                                i += 2;
                                continue;
                            }
                            if (i + 2 >= remainingWord.length() || remainingWord.charAt(i) != '&' || remainingWord.charAt(i + 1) != '#') break;
                            int endIndex = Math.min(i + 8, remainingWord.length());
                            colorCodes.append(remainingWord.substring(i, endIndex));
                            i = endIndex;
                        }
                        if (i > 0) {
                            remainingWord.delete(0, i);
                        }
                        String visiblePart = remainingWord.toString().replaceAll("\u00a7[0-9a-fk-or]|&#[0-9a-fA-F]{6}", "");
                        int charsToTake = Math.min(visiblePart.length(), maxLength);
                        StringBuilder linePart = new StringBuilder(currentColor).append((CharSequence)colorCodes);
                        int charsTaken = 0;
                        i = 0;
                        while (i < remainingWord.length() && charsTaken < charsToTake) {
                            if (remainingWord.charAt(i) == '\u00a7' && i + 1 < remainingWord.length()) {
                                linePart.append(remainingWord.charAt(i)).append(remainingWord.charAt(i + 1));
                                i += 2;
                                continue;
                            }
                            if (i + 2 < remainingWord.length() && remainingWord.charAt(i) == '&' && remainingWord.charAt(i + 1) == '#') {
                                int endIndex = Math.min(i + 8, remainingWord.length());
                                linePart.append(remainingWord.substring(i, endIndex));
                                i = endIndex;
                                continue;
                            }
                            linePart.append(remainingWord.charAt(i));
                            ++i;
                            ++charsTaken;
                        }
                        lines.add(linePart.toString());
                        Matcher matcher = colorPattern.matcher(linePart.toString());
                        while (matcher.find()) {
                            currentColor = matcher.group();
                        }
                        remainingWord.delete(0, i);
                        if (remainingWord.length() <= 0) continue;
                        remainingWord.insert(0, currentColor);
                    }
                    currentLine = new StringBuilder();
                    continue;
                }
                currentLine.append(word);
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
            }
            if (lines.isEmpty()) {
                lines.add(text);
            }
            return lines;
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("[nonchat] Error splitting text into lines: " + e.getMessage());
            ArrayList<String> fallback = new ArrayList<String>();
            fallback.add(text);
            return fallback;
        }
    }

    public static void clearPool() {
        try {
            armorStandPool.clear();
        }
        catch (Exception e) {
            Bukkit.getLogger().fine("[nonchat] Error clearing armor stand pool: " + e.getMessage());
        }
    }

    private static class ObjectPool<T> {
        private final List<T> pool = new ArrayList<T>();
        private final int maxSize;

        public ObjectPool(int maxSize) {
            this.maxSize = maxSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T acquire(Supplier<T> creator) {
            try {
                List<T> list = this.pool;
                synchronized (list) {
                    if (!this.pool.isEmpty()) {
                        ArmorStand as;
                        T obj = this.pool.remove(this.pool.size() - 1);
                        if (obj instanceof ArmorStand && (as = (ArmorStand)obj).isDead()) {
                            return creator.get();
                        }
                        return obj;
                    }
                }
                return creator.get();
            }
            catch (Exception e) {
                Bukkit.getLogger().fine("[nonchat] Error acquiring from pool: " + e.getMessage());
                return creator.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(T obj) {
            block8: {
                try {
                    if (!(obj instanceof ArmorStand)) break block8;
                    ArmorStand as = (ArmorStand)obj;
                    if (as.isDead()) {
                        return;
                    }
                    as.setCustomNameVisible(false);
                    as.customName(null);
                    List<T> list = this.pool;
                    synchronized (list) {
                        if (this.pool.size() < this.maxSize) {
                            this.pool.add(obj);
                        } else {
                            as.remove();
                        }
                    }
                }
                catch (Exception e) {
                    Bukkit.getLogger().fine("[nonchat] Error releasing to pool: " + e.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            try {
                List<T> list = this.pool;
                synchronized (list) {
                    this.pool.forEach(obj -> {
                        try {
                            if (obj instanceof ArmorStand) {
                                ArmorStand armorStand = (ArmorStand)obj;
                                armorStand.remove();
                            }
                        }
                        catch (Exception e) {
                            Bukkit.getLogger().fine("[nonchat] Error removing armor stand from pool: " + e.getMessage());
                        }
                    });
                    this.pool.clear();
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().fine("[nonchat] Error clearing pool: " + e.getMessage());
            }
        }
    }
}

