/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.core.colors;

import com.nonxedy.nonchat.util.core.colors.LRUCache;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.entity.Player;

public class ColorUtil {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");
    private static final Pattern LEGACY_COLOR_PATTERN = Pattern.compile("&[0-9a-fklmnor]");
    private static final Pattern SECTION_COLOR_PATTERN = Pattern.compile("\u00a7[0-9a-fklmnor]");
    private static final Pattern MINIMESSAGE_PATTERN = Pattern.compile("<[^>]+>");
    private static final Pattern MINIMESSAGE_TAG_PATTERN = Pattern.compile("<(?:[/#]?(?:color|c|gradient|rainbow|bold|b|italic|i|underlined|u|strikethrough|st|obfuscated|obf|reset|r|shadow|hover|click|insertion|font|transition|selector|keybind|translatable|score|nbt|newline|br|lang|key|translate|#[0-9a-fA-F]{6}|[a-z_]+)(?::[^>]*)?|/)>");
    private static final Pattern GRADIENT_PATTERN = Pattern.compile("<gradient:[^>]+>");
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final LRUCache<String, String> COLOR_CACHE = new LRUCache(1000);
    private static final Map<String, Component> COMPONENT_CACHE = Collections.synchronizedMap(new WeakHashMap());

    public static String parseColor(String message) {
        if (message == null) {
            return "";
        }
        String cached = COLOR_CACHE.get(message);
        if (cached != null) {
            return cached;
        }
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuilder buffer = new StringBuilder(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + group)).toString());
        }
        matcher.appendTail(buffer);
        String result = ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
        COLOR_CACHE.put(message, result);
        return result;
    }

    public static Component parseComponentCached(String message) {
        if (message == null || message.isEmpty()) {
            return Component.empty();
        }
        return COMPONENT_CACHE.computeIfAbsent(message, m -> {
            if (ColorUtil.containsMiniMessageTags(m)) {
                return ColorUtil.parseMiniMessageComponent(m);
            }
            String legacyMessage = ColorUtil.parseColor(m);
            return LegacyComponentSerializer.legacySection().deserialize(legacyMessage);
        });
    }

    public static Component parseComponent(String message) {
        if (message == null || message.isEmpty()) {
            return Component.empty();
        }
        if (ColorUtil.containsMiniMessageTags(message)) {
            return ColorUtil.parseMiniMessageComponent(message);
        }
        String legacyMessage = ColorUtil.parseColor(message);
        return LegacyComponentSerializer.legacySection().deserialize(legacyMessage);
    }

    public static Component parseComponent(String message, Player player) {
        if (player != null && !player.hasPermission("nonchat.color")) {
            return Component.text((String)ColorUtil.stripAllColors(message));
        }
        return ColorUtil.parseComponent(message);
    }

    public static Component parseMiniMessageComponent(String message) {
        if (message == null || message.isEmpty()) {
            return Component.empty();
        }
        try {
            if (ColorUtil.containsLegacyCodes(message)) {
                String preparedMessage = ColorUtil.prepareMixedFormatMessage(message);
                return MINI_MESSAGE.deserialize((Object)preparedMessage);
            }
            return MINI_MESSAGE.deserialize((Object)message);
        }
        catch (Exception e) {
            String legacyMessage = ColorUtil.parseColor(message);
            return LegacyComponentSerializer.legacySection().deserialize(legacyMessage);
        }
    }

    public static Component parseMiniMessageComponent(String message, Player player) {
        if (player != null && !player.hasPermission("nonchat.color")) {
            return Component.text((String)ColorUtil.stripAllColors(message));
        }
        return ColorUtil.parseMiniMessageComponent(message);
    }

    private static String prepareMixedFormatMessage(String message) {
        if (message == null || message.isEmpty()) {
            return "";
        }
        String result = message;
        if (!result.contains("<#")) {
            Matcher matcher = HEX_PATTERN.matcher(result);
            StringBuffer buffer = new StringBuffer(result.length() + 32);
            while (matcher.find()) {
                String hexColor = matcher.group(1);
                matcher.appendReplacement(buffer, "<#" + hexColor + ">");
            }
            matcher.appendTail(buffer);
            result = buffer.toString();
        }
        result = ColorUtil.replaceLegacyCode(result, "&0", "<black>");
        result = ColorUtil.replaceLegacyCode(result, "&1", "<dark_blue>");
        result = ColorUtil.replaceLegacyCode(result, "&2", "<dark_green>");
        result = ColorUtil.replaceLegacyCode(result, "&3", "<dark_aqua>");
        result = ColorUtil.replaceLegacyCode(result, "&4", "<dark_red>");
        result = ColorUtil.replaceLegacyCode(result, "&5", "<dark_purple>");
        result = ColorUtil.replaceLegacyCode(result, "&6", "<gold>");
        result = ColorUtil.replaceLegacyCode(result, "&7", "<gray>");
        result = ColorUtil.replaceLegacyCode(result, "&8", "<dark_gray>");
        result = ColorUtil.replaceLegacyCode(result, "&9", "<blue>");
        result = ColorUtil.replaceLegacyCode(result, "&a", "<green>");
        result = ColorUtil.replaceLegacyCode(result, "&b", "<aqua>");
        result = ColorUtil.replaceLegacyCode(result, "&c", "<red>");
        result = ColorUtil.replaceLegacyCode(result, "&d", "<light_purple>");
        result = ColorUtil.replaceLegacyCode(result, "&e", "<yellow>");
        result = ColorUtil.replaceLegacyCode(result, "&f", "<white>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a70", "<black>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a71", "<dark_blue>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a72", "<dark_green>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a73", "<dark_aqua>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a74", "<dark_red>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a75", "<dark_purple>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a76", "<gold>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a77", "<gray>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a78", "<dark_gray>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a79", "<blue>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a7a", "<green>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a7b", "<aqua>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a7c", "<red>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a7d", "<light_purple>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a7e", "<yellow>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a7f", "<white>");
        result = ColorUtil.replaceLegacyCode(result, "&l", "<bold>");
        result = ColorUtil.replaceLegacyCode(result, "&m", "<strikethrough>");
        result = ColorUtil.replaceLegacyCode(result, "&n", "<underlined>");
        result = ColorUtil.replaceLegacyCode(result, "&o", "<italic>");
        result = ColorUtil.replaceLegacyCode(result, "&k", "<obfuscated>");
        result = ColorUtil.replaceLegacyCode(result, "&r", "<reset>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a7l", "<bold>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a7m", "<strikethrough>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a7n", "<underlined>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a7o", "<italic>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a7k", "<obfuscated>");
        result = ColorUtil.replaceLegacyCode(result, "\u00a7r", "<reset>");
        return result;
    }

    private static String replaceLegacyCode(String text, String legacyCode, String miniMessageTag) {
        if (!text.contains(legacyCode)) {
            return text;
        }
        return text.replace(legacyCode, miniMessageTag);
    }

    private static boolean containsMiniMessageTags(String message) {
        if (message == null || message.isEmpty()) {
            return false;
        }
        return MINIMESSAGE_TAG_PATTERN.matcher(message).find();
    }

    private static boolean containsLegacyCodes(String message) {
        if (message == null || message.isEmpty()) {
            return false;
        }
        return HEX_PATTERN.matcher(message).find() || LEGACY_COLOR_PATTERN.matcher(message).find() || SECTION_COLOR_PATTERN.matcher(message).find();
    }

    public static String stripAllColors(String message) {
        if (message == null) {
            return "";
        }
        String result = message;
        result = HEX_PATTERN.matcher(result).replaceAll("");
        result = LEGACY_COLOR_PATTERN.matcher(result).replaceAll("");
        result = SECTION_COLOR_PATTERN.matcher(result).replaceAll("");
        result = MINIMESSAGE_PATTERN.matcher(result).replaceAll("");
        return result;
    }

    public static boolean hasColorCodes(String message) {
        if (message == null) {
            return false;
        }
        return HEX_PATTERN.matcher(message).find() || LEGACY_COLOR_PATTERN.matcher(message).find() || SECTION_COLOR_PATTERN.matcher(message).find() || MINIMESSAGE_PATTERN.matcher(message).find();
    }

    public static String processMessageWithPermission(String message, Player player) {
        if (player != null && !player.hasPermission("nonchat.color")) {
            return ColorUtil.stripAllColors(message);
        }
        return ColorUtil.parseColor(message);
    }

    public static boolean containsGradient(String message) {
        if (message == null || message.isEmpty()) {
            return false;
        }
        return GRADIENT_PATTERN.matcher(message).find();
    }

    public static Component parseConfigComponent(String message) {
        if (message == null || message.isEmpty()) {
            return Component.empty();
        }
        if (ColorUtil.containsMiniMessageTags(message) || ColorUtil.containsGradient(message)) {
            try {
                return ColorUtil.parseMiniMessageComponent(message);
            }
            catch (Exception e) {
                String legacyMessage = ColorUtil.parseColor(message);
                return LegacyComponentSerializer.legacySection().deserialize(legacyMessage);
            }
        }
        String legacyMessage = ColorUtil.parseColor(message);
        return LegacyComponentSerializer.legacySection().deserialize(legacyMessage);
    }
}

