/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.core.debugging;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nonxedy.nonchat.Nonchat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class Debugger {
    private final Plugin plugin;
    private final File logsFolder;
    private final int logRetentionDays;
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
    private final Gson gson = new GsonBuilder().create();

    public Debugger(Nonchat plugin, int retentionDays) {
        this.plugin = plugin;
        this.logsFolder = new File(plugin.getDataFolder(), "debug_logs");
        this.logRetentionDays = retentionDays > 0 ? retentionDays : 7;
        this.initialize();
    }

    private void initialize() {
        if (!this.logsFolder.exists()) {
            this.logsFolder.mkdirs();
        }
        this.rotateLogs();
    }

    private synchronized void rotateLogs() {
        try {
            LocalDate cutoffDate = LocalDate.now().minusDays(this.logRetentionDays);
            File[] logFiles = this.logsFolder.listFiles((dir, name) -> name.startsWith("debug_") && name.endsWith(".log"));
            if (logFiles != null) {
                for (File logFile : logFiles) {
                    String dateStr = logFile.getName().substring(6, 16);
                    LocalDate logDate = LocalDate.parse(dateStr, this.dateFormatter);
                    if (!logDate.isBefore(cutoffDate)) continue;
                    Files.delete(logFile.toPath());
                }
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to rotate debug logs: {0}", e.getMessage());
        }
    }

    private File getCurrentLogFile() {
        String fileName = "debug_" + LocalDate.now().format(this.dateFormatter) + ".log";
        return new File(this.logsFolder, fileName);
    }

    private synchronized void writeLogEntry(Map<String, Object> logData) {
        if (!this.plugin.getConfig().getBoolean("debug", false)) {
            return;
        }
        File logFile = this.getCurrentLogFile();
        try (PrintWriter writer = new PrintWriter(new FileWriter(logFile, true));){
            writer.println("=== " + LocalDateTime.now().format(this.timeFormatter) + " ===");
            writer.println("Level: " + String.valueOf(logData.get("level")));
            writer.println("Module: " + String.valueOf(logData.get("module")));
            writer.println("Message: " + String.valueOf(logData.get("message")));
            if (logData.containsKey("exception")) {
                Map excData = (Map)logData.get("exception");
                writer.println("\nException: ");
                writer.println("Type: " + String.valueOf(excData.get("type")));
                writer.println("Message: " + String.valueOf(excData.get("message")));
                writer.println("Stacktrace:");
                List stacktrace = (List)excData.get("stacktrace");
                for (String trace : stacktrace) {
                    writer.println("  " + trace);
                }
            }
            writer.println();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to write debug log: {0}", e.getMessage());
        }
    }

    public void debug(String module, String message) {
        HashMap<String, Object> logData = new HashMap<String, Object>();
        logData.put("level", "DEBUG");
        logData.put("module", module);
        logData.put("message", message);
        this.writeLogEntry(logData);
    }

    public void info(String module, String message) {
        HashMap<String, Object> logData = new HashMap<String, Object>();
        logData.put("level", "INFO");
        logData.put("module", module);
        logData.put("message", message);
        this.writeLogEntry(logData);
    }

    public void warn(String module, String message) {
        HashMap<String, Object> logData = new HashMap<String, Object>();
        logData.put("level", "WARN");
        logData.put("module", module);
        logData.put("message", message);
        this.writeLogEntry(logData);
    }

    public void error(String module, String message, Throwable exception) {
        HashMap<String, Object> logData = new HashMap<String, Object>();
        logData.put("level", "ERROR");
        logData.put("module", module);
        logData.put("message", message);
        if (exception != null) {
            HashMap<String, Object> excData = new HashMap<String, Object>();
            excData.put("type", exception.getClass().getSimpleName());
            excData.put("message", exception.getMessage());
            LinkedList<String> stackTrace = new LinkedList<String>();
            for (StackTraceElement elem : exception.getStackTrace()) {
                stackTrace.add(elem.toString());
            }
            excData.put("stacktrace", stackTrace);
            logData.put("exception", excData);
        }
        this.writeLogEntry(logData);
    }

    public void cleanupAllLogs() {
        try {
            File[] logFiles = this.logsFolder.listFiles((dir, name) -> name.startsWith("debug_") && name.endsWith(".log"));
            if (logFiles != null) {
                for (File logFile : logFiles) {
                    Files.delete(logFile.toPath());
                }
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to clean debug logs: {0}", e.getMessage());
        }
    }

    public List<String> getRecentLogs(int count) {
        List<String> list;
        LinkedList<String> logs = new LinkedList<String>();
        File logFile = this.getCurrentLogFile();
        if (!logFile.exists()) {
            return logs;
        }
        BufferedReader reader = new BufferedReader(new FileReader(logFile));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                logs.add(line);
                if (logs.size() <= count * 2) continue;
                logs.remove(0);
            }
            list = logs.subList(Math.max(0, logs.size() - count), logs.size());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to read debug logs: {0}", e.getMessage());
                return List.of();
            }
        }
        reader.close();
        return list;
    }
}

