/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.integration.external;

import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.user.User;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class IntegrationUtil {
    private static LuckPerms luckPerms;
    private static Economy economy;
    private static boolean placeholderAPIEnabled;

    public static void setupIntegrations() {
        IntegrationUtil.setupLuckPerms();
        IntegrationUtil.setupEconomy();
        try {
            boolean bl = placeholderAPIEnabled = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
            if (placeholderAPIEnabled) {
                Bukkit.getLogger().info("[nonchat] PlaceholderAPI integration enabled");
            } else {
                Bukkit.getLogger().info("[nonchat] PlaceholderAPI not available - placeholder features will be disabled");
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("[nonchat] Error checking PlaceholderAPI: " + e.getMessage());
            placeholderAPIEnabled = false;
        }
    }

    private static void setupLuckPerms() {
        try {
            RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
            if (provider != null) {
                luckPerms = (LuckPerms)provider.getProvider();
                Bukkit.getLogger().info("[nonchat] LuckPerms integration enabled");
            } else {
                Bukkit.getLogger().info("[nonchat] LuckPerms not available - permission features will be disabled");
            }
        }
        catch (NoClassDefFoundError e) {
            Bukkit.getLogger().info("[nonchat] LuckPerms not installed - permission features will be disabled");
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("[nonchat] Error setting up LuckPerms: " + e.getMessage());
        }
    }

    private static void setupEconomy() {
        try {
            RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Economy.class);
            if (provider != null) {
                economy = (Economy)provider.getProvider();
                Bukkit.getLogger().info("[nonchat] Vault Economy integration enabled");
            } else {
                Bukkit.getLogger().info("[nonchat] Vault Economy not available - economy features will be disabled");
            }
        }
        catch (NoClassDefFoundError e) {
            Bukkit.getLogger().info("[nonchat] Vault not installed - economy features will be disabled");
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("[nonchat] Error setting up Vault Economy: " + e.getMessage());
        }
    }

    public static String getPlayerPrefix(Player player) {
        try {
            if (luckPerms != null) {
                User user = luckPerms.getUserManager().getUser(player.getUniqueId());
                return user != null ? user.getCachedData().getMetaData().getPrefix() : "";
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().fine("[nonchat] Error getting player prefix: " + e.getMessage());
        }
        return "";
    }

    public static String getBalance(Player player) {
        try {
            if (economy != null) {
                return String.format("%.2f", economy.getBalance((OfflinePlayer)player));
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().fine("[nonchat] Error getting player balance: " + e.getMessage());
        }
        return "0";
    }

    public static String getPlayTime(Player player) {
        try {
            if (placeholderAPIEnabled) {
                return PlaceholderAPI.setPlaceholders((Player)player, (String)"%statistic_time_played%");
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().fine("[nonchat] Error getting player play time: " + e.getMessage());
        }
        return "0h";
    }

    public static String processPlaceholders(Player player, String text) {
        try {
            if (placeholderAPIEnabled && player != null && text != null) {
                try {
                    return PlaceholderAPI.setPlaceholders((Player)player, (String)text);
                }
                catch (Exception e) {
                    Bukkit.getLogger().log(Level.WARNING, "[nonchat] Error processing placeholder: {0}", e.getMessage());
                    return text;
                }
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().fine("[nonchat] PlaceholderAPI not available for processing placeholders");
        }
        return text;
    }
}

