/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.items.display;

import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import com.nonxedy.nonchat.util.items.localization.ItemLocalizationUtil;
import com.nonxedy.nonchat.util.lang.TranslationUtil;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemDisplayUtil {
    public static Component createItemComponent(ItemStack item, String format) {
        if (item == null) {
            return Component.text((String)"No item");
        }
        Component itemComponent = ItemLocalizationUtil.createTranslatableItemComponent(item);
        return itemComponent.hoverEvent(ItemDisplayUtil.createItemHoverEvent(item));
    }

    public static Component createBracketedItemComponent(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            Component noItemComponent = TranslationUtil.getNoItemComponent();
            return ((TextComponent)((TextComponent)Component.text((String)"[").append(noItemComponent)).append((Component)Component.text((String)"]"))).color((TextColor)NamedTextColor.GRAY);
        }
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            Component displayNameComponent = item.getItemMeta().displayName();
            Component itemComponent = ((TextComponent)((TextComponent)Component.text((String)"[").append(displayNameComponent)).append((Component)Component.text((String)"]"))).hoverEvent(ItemDisplayUtil.createItemHoverEvent(item));
            return itemComponent;
        }
        Component translatableComponent = ItemLocalizationUtil.createTranslatableItemComponent(item);
        Component itemComponent = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[").append(translatableComponent)).append((Component)Component.text((String)"]"))).color((TextColor)NamedTextColor.WHITE)).hoverEvent(ItemDisplayUtil.createItemHoverEvent(item));
        return itemComponent;
    }

    public static HoverEvent<Component> createItemHoverEvent(ItemStack item) {
        Component hoverText = ItemDisplayUtil.createItemHoverText(item);
        return HoverEvent.showText((Component)hoverText);
    }

    private static Component createItemHoverText(ItemStack item) {
        List lore;
        ArrayList<Object> lines = new ArrayList<Object>();
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            Component displayNameComponent = item.getItemMeta().displayName().decoration(TextDecoration.ITALIC, false).decoration(TextDecoration.BOLD, false);
            lines.add(displayNameComponent);
        } else {
            Component translatableComponent = ItemLocalizationUtil.createTranslatableItemComponent(item).color((TextColor)NamedTextColor.WHITE).decoration(TextDecoration.ITALIC, false).decoration(TextDecoration.BOLD, false);
            lines.add(translatableComponent);
        }
        if (item.hasItemMeta() && item.getItemMeta().hasEnchants()) {
            lines.add(Component.text((String)""));
            item.getEnchantments().forEach((enchantment, level) -> {
                Component enchantmentComponent = ItemLocalizationUtil.getLocalizedEnchantmentComponent(enchantment);
                String enchLevel = ItemDisplayUtil.formatEnchantmentLevel(level);
                Component enchantmentLine = enchantmentComponent.append((Component)Component.text((String)(" " + enchLevel))).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false);
                lines.add(enchantmentLine);
            });
        }
        if (item.hasItemMeta() && item.getItemMeta().hasLore() && (lore = item.getItemMeta().getLore()) != null && !lore.isEmpty()) {
            lines.add(Component.text((String)""));
            for (String loreLine : lore) {
                Component loreComponent = ColorUtil.parseComponent(loreLine);
                lines.add(loreComponent);
            }
        }
        TextComponent result = Component.empty();
        for (int i = 0; i < lines.size(); ++i) {
            result = result.append((Component)lines.get(i));
            if (i >= lines.size() - 1) continue;
            result = result.append((Component)Component.newline());
        }
        return result;
    }

    public static String getItemName(ItemStack item) {
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            return PlainTextComponentSerializer.plainText().serialize(item.getItemMeta().displayName());
        }
        return ItemDisplayUtil.formatMaterialName(item.getType().name());
    }

    private static String formatMaterialName(String materialName) {
        String[] words = materialName.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            if (words[i].length() <= 0) continue;
            result.append(Character.toUpperCase(words[i].charAt(0)));
            if (words[i].length() <= 1) continue;
            result.append(words[i].substring(1));
        }
        return result.toString();
    }

    private static String formatEnchantmentLevel(int level) {
        return switch (level) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            case 6 -> "VI";
            case 7 -> "VII";
            case 8 -> "VIII";
            case 9 -> "IX";
            case 10 -> "X";
            default -> String.valueOf(level);
        };
    }

    public static Component getHeldItemInfo(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        return ItemDisplayUtil.createItemComponent(item, "&6[Item: &r{item}&6]");
    }
}

