/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.command.impl;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.service.ConfigService;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class NonchatCommand
implements CommandExecutor,
TabCompleter {
    private final Nonchat plugin;
    private final PluginMessages messages;
    private final ConfigService configService;

    public NonchatCommand(Nonchat plugin, ConfigService configService) {
        this.plugin = plugin;
        this.configService = configService;
        this.messages = configService.getMessages();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        this.plugin.logCommand(command.getName(), args);
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                return this.handleReloadCommand(sender);
            }
            case "help": {
                return this.handleHelpCommand(sender);
            }
        }
        this.sendHelpMessage(sender);
        return true;
    }

    private boolean handleReloadCommand(CommandSender sender) {
        if (!sender.hasPermission("nonchat.reload")) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
            this.plugin.logError("Permission denied: nonchat.reload");
            return true;
        }
        try {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("reloading")));
            this.plugin.logResponse("Initiating config reload...");
            this.executeReload();
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("reloaded")));
            this.plugin.logResponse("Configuration reload successful");
        }
        catch (Exception e) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("reload-failed")));
            this.plugin.logError("Configuration reload failed: " + e.getMessage());
        }
        return true;
    }

    private void executeReload() {
        this.configService.reload();
        this.plugin.reloadConfig();
        Nonchat nonchat = this.plugin;
        if (nonchat instanceof Nonchat) {
            Nonchat nonchat2 = nonchat;
            nonchat2.reloadServices();
        }
    }

    private boolean handleHelpCommand(CommandSender sender) {
        if (!sender.hasPermission("nonchat.help")) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
            this.plugin.logError("Permission denied: nonchat.help");
            return true;
        }
        this.sendHelpMessage(sender);
        return true;
    }

    private void sendHelpMessage(CommandSender sender) {
        try {
            Component helpMessage = ((TextComponent)((TextComponent)Component.empty().append(ColorUtil.parseComponentCached(this.messages.getString("help")))).append((Component)Component.newline())).append(this.getCommandsList());
            sender.sendMessage(helpMessage);
            this.plugin.logResponse("Help message sent successfully");
        }
        catch (Exception e) {
            this.plugin.logError("Failed to send help message: " + e.getMessage());
        }
    }

    private Component getCommandsList() {
        return ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(ColorUtil.parseComponentCached(this.messages.getString("nreload")))).append((Component)Component.newline())).append(ColorUtil.parseComponentCached(this.messages.getString("help-command")))).append((Component)Component.newline())).append(ColorUtil.parseComponentCached(this.messages.getString("server-command")))).append((Component)Component.newline())).append(ColorUtil.parseComponentCached(this.messages.getString("message-command")))).append((Component)Component.newline())).append(ColorUtil.parseComponentCached(this.messages.getString("broadcast-command")))).append((Component)Component.newline())).append(ColorUtil.parseComponentCached(this.messages.getString("ignore-command")))).append((Component)Component.newline())).append(ColorUtil.parseComponentCached(this.messages.getString("spy-command")))).append((Component)Component.newline())).append(ColorUtil.parseComponentCached(this.messages.getString("me-command")))).append((Component)Component.newline())).append(ColorUtil.parseComponentCached(this.messages.getString("roll-command")))).append((Component)Component.newline())).append(ColorUtil.parseComponentCached(this.messages.getString("channel-command")).append((Component)Component.newline()).append(ColorUtil.parseComponentCached(this.messages.getString("reply-command"))));
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> subCommands = new ArrayList<String>();
            if (sender.hasPermission("nonchat.reload")) {
                subCommands.add("reload");
            }
            if (sender.hasPermission("nonchat.help")) {
                subCommands.add("help");
            }
            return this.filterStartingWith(args[0], subCommands);
        }
        return Collections.emptyList();
    }

    private List<String> filterStartingWith(String prefix, List<String> options) {
        ArrayList<String> result = new ArrayList<String>();
        for (String option : options) {
            if (!option.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            result.add(option);
        }
        return result;
    }
}

