/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.command.impl;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SpyCommand
implements CommandExecutor {
    private final Nonchat plugin;
    private final PluginMessages messages;
    private final PluginConfig pluginConfig;
    private final Set<Player> spyPlayers;

    public SpyCommand(Nonchat plugin, PluginMessages messages, PluginConfig pluginConfig) {
        this.plugin = plugin;
        this.messages = messages;
        this.pluginConfig = pluginConfig;
        this.spyPlayers = new HashSet<Player>();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        this.plugin.logCommand(command.getName(), args);
        Player player = (Player)sender;
        if (!(sender instanceof Player)) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("player-only")));
            return true;
        }
        if (!player.hasPermission("nonchat.spy")) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
            this.plugin.logError("Player " + player.getName() + " tried to use spy command without permission");
            return true;
        }
        this.toggleSpyMode(player);
        return true;
    }

    private void toggleSpyMode(Player player) {
        try {
            if (this.spyPlayers.contains(player)) {
                this.spyPlayers.remove(player);
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("spy-mode-disabled")));
                this.plugin.logResponse("Spy mode disabled for " + player.getName());
            } else {
                this.spyPlayers.add(player);
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("spy-mode-enabled")));
                this.plugin.logResponse("Spy mode enabled for " + player.getName());
            }
        }
        catch (Exception e) {
            this.plugin.logError("Error toggling spy mode for " + player.getName() + ": " + e.getMessage());
        }
    }

    public void onPrivateMessage(Player sender, Player target, Component message) {
        String plainMessage = PlainTextComponentSerializer.plainText().serialize(message);
        String spyFormat = this.pluginConfig.getSpyFormat().replace("{sender}", sender.getName()).replace("{target}", target.getName()).replace("{message}", plainMessage);
        for (Player spy : this.spyPlayers) {
            if (spy == sender || spy == target || !spy.isOnline()) continue;
            spy.sendMessage(ColorUtil.parseComponent(spyFormat));
            this.plugin.logResponse("Spy " + spy.getName() + " received message: " + spyFormat);
        }
    }

    public boolean isSpying(Player player) {
        return this.spyPlayers.contains(player);
    }

    public Set<Player> getSpyPlayers() {
        return new HashSet<Player>(this.spyPlayers);
    }
}

