/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.hook;

import com.nonxedy.nonchat.Nonchat;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.DiscordGuildMessageReceivedEvent;
import github.scarsz.discordsrv.api.events.DiscordReadyEvent;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.util.DiscordUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DiscordSRVHook {
    private final Nonchat plugin;
    private DiscordSRV discordSRV;
    private boolean isHooked = false;

    public DiscordSRVHook(Nonchat plugin) {
        this.plugin = plugin;
        try {
            Plugin discordSRVPlugin = Bukkit.getPluginManager().getPlugin("DiscordSRV");
            if (discordSRVPlugin != null && discordSRVPlugin.isEnabled()) {
                this.discordSRV = DiscordSRV.getPlugin();
                DiscordSRV.api.subscribe((Object)this);
                this.isHooked = true;
                plugin.logResponse("Successfully hooked into DiscordSRV!");
            } else {
                plugin.logError("DiscordSRV plugin not found or is disabled. DiscordSRV integration will not be available.");
            }
        }
        catch (Exception e) {
            plugin.logError("Failed to hook into DiscordSRV: " + e.getMessage());
        }
    }

    public boolean sendMessageToChannel(String channelName, String message) {
        if (!this.isHooked || this.discordSRV == null) {
            return false;
        }
        try {
            this.plugin.logResponse("DiscordSRVHook: Sending message to channel '" + channelName + "': " + message);
            TextChannel channel = this.discordSRV.getDestinationTextChannelForGameChannelName(channelName);
            if (channel != null) {
                this.plugin.logResponse("Found Discord channel: " + channel.getName() + " (" + channel.getId() + ")");
                DiscordUtil.sendMessage((TextChannel)channel, (String)message);
                return true;
            }
            this.plugin.logError("DiscordSRV channel not found: " + channelName);
            return false;
        }
        catch (Exception e) {
            this.plugin.logError("Error sending message to Discord: " + e.getMessage());
            return false;
        }
    }

    @Subscribe
    public void onDiscordReady(DiscordReadyEvent event) {
        this.plugin.logResponse("Connected to Discord via DiscordSRV!");
    }

    @Subscribe
    public void onDiscordMessageReceived(DiscordGuildMessageReceivedEvent event) {
        if (event.getAuthor().isBot()) {
            return;
        }
        String minecraftChannel = this.discordSRV.getDestinationGameChannelNameForTextChannel(event.getChannel());
        if (minecraftChannel != null) {
            String formattedMessage = "\u00a79[Discord] \u00a7b" + event.getAuthor().getName() + "\u00a7f: " + event.getMessage().getContentDisplay();
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendMessage(formattedMessage);
            }
        }
    }

    public boolean isHooked() {
        return this.isHooked;
    }

    public void shutdown() {
        if (this.isHooked && this.discordSRV != null) {
            try {
                DiscordSRV.api.unsubscribe((Object)this);
                this.plugin.logResponse("Successfully unhooked from DiscordSRV");
            }
            catch (Exception e) {
                this.plugin.logError("Error while unhooking from DiscordSRV: " + e.getMessage());
            }
        }
    }
}

