/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.chat.filters;

import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextDecoration;

public class LinkDetector {
    private static final Pattern URL_PATTERN = Pattern.compile("(?i)\\b((?:https?://|www\\.)\\S+\\.[a-z]{2,}\\S*)", 2);
    private static PluginMessages messages;

    public static void initialize(PluginMessages messages) {
        LinkDetector.messages = messages;
    }

    public static Component makeLinksClickable(String text) {
        if (text == null || text.isEmpty()) {
            return Component.empty();
        }
        Matcher matcher = URL_PATTERN.matcher(text);
        if (!matcher.find()) {
            return ColorUtil.parseComponent(text);
        }
        matcher.reset();
        TextComponent.Builder builder = Component.text();
        int lastEnd = 0;
        while (matcher.find()) {
            String beforeUrl = text.substring(lastEnd, matcher.start());
            if (!beforeUrl.isEmpty()) {
                builder.append(ColorUtil.parseComponent(beforeUrl));
            }
            String url = matcher.group();
            Component linkComponent = LinkDetector.createLinkComponent(url);
            builder.append(linkComponent);
            lastEnd = matcher.end();
        }
        String afterLastUrl = text.substring(lastEnd);
        if (!afterLastUrl.isEmpty()) {
            builder.append(ColorUtil.parseComponent(afterLastUrl));
        }
        return builder.build();
    }

    private static Component createLinkComponent(String url) {
        TextComponent hoverComponent;
        Object clickableUrl = url;
        if (url.toLowerCase().startsWith("www.")) {
            clickableUrl = "https://" + url;
        }
        if (messages != null) {
            String hoverText = messages.getString("link-hover").replace("{url}", (CharSequence)clickableUrl);
            hoverComponent = ColorUtil.parseComponent(hoverText);
        } else {
            hoverComponent = Component.text((String)("Click to open: " + (String)clickableUrl));
        }
        return ((TextComponent)((TextComponent)Component.text((String)url).clickEvent(ClickEvent.openUrl((String)clickableUrl))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComponent))).decoration(TextDecoration.UNDERLINED, true);
    }
}

