/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.core.updates;

import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.util.chat.filters.LinkDetector;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import com.nonxedy.nonchat.util.folia.FoliaDetector;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class UpdateChecker
implements Listener {
    private final Nonchat plugin;
    private final String currentVersion;
    private static final String MODRINTH_API = "https://api.modrinth.com/v2/project/nonchat/version";
    private String latestVersion = null;
    private String downloadUrl = null;
    private boolean updateAvailable = false;

    public UpdateChecker(Nonchat plugin) {
        Nonchat nonchatPlugin;
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
        if (plugin instanceof Nonchat && !(nonchatPlugin = plugin).getConfigService().getConfig().isUpdateCheckerEnabled()) {
            plugin.logResponse("Update checker is disabled in config");
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        plugin.logResponse("Initializing update checker for nonchat version " + this.currentVersion);
        this.checkForUpdates().thenAccept(hasUpdate -> {
            if (hasUpdate.booleanValue()) {
                plugin.logResponse("New version available: " + this.latestVersion);
                plugin.logResponse("Download: " + this.downloadUrl);
                this.notifyOnlinePlayers();
            } else {
                plugin.logResponse("You are using the latest version of nonchat!");
            }
        });
    }

    public CompletableFuture<Boolean> checkForUpdates() {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        FoliaDetector.getScheduler((Plugin)this.plugin).runTaskAsynchronously(() -> {
            try {
                URL url = new URL(MODRINTH_API);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                this.plugin.logResponse("Checking for updates from: https://api.modrinth.com/v2/project/nonchat/version");
                JsonObject latestVersion = JsonParser.parseReader((Reader)new InputStreamReader(connection.getInputStream())).getAsJsonArray().get(0).getAsJsonObject();
                this.latestVersion = latestVersion.get("version_number").getAsString();
                this.downloadUrl = "https://modrinth.com/plugin/nonchat/version/" + this.latestVersion;
                this.plugin.logResponse("Current version: " + this.currentVersion);
                this.plugin.logResponse("Latest version: " + this.latestVersion);
                this.updateAvailable = !this.currentVersion.equals(this.latestVersion);
                this.plugin.logResponse("Update available: " + this.updateAvailable);
                future.complete(this.updateAvailable);
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                this.plugin.logError("Failed to check for updates: " + e.getMessage());
                future.complete(false);
            }
        });
        return future;
    }

    private void notifyOnlinePlayers() {
        if (!this.updateAvailable) {
            return;
        }
        FoliaDetector.getScheduler((Plugin)this.plugin).runTask(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!this.hasUpdatePermission(player)) continue;
                this.sendUpdateNotification(player);
            }
        });
    }

    private boolean hasUpdatePermission(Player player) {
        boolean hasPermission = player.hasPermission("nonchat.*") || player.isOp();
        return hasPermission;
    }

    private void sendUpdateNotification(Player player) {
        try {
            player.sendMessage(ColorUtil.parseComponent("&#FFAFFB[nonchat] &#ffffff A new version is available: &#FFAFFB" + this.latestVersion));
            BuildableComponent downloadMessage = ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(ColorUtil.parseComponent("&#FFAFFB[nonchat] &#ffffffDownload: "))).append(LinkDetector.makeLinksClickable(this.downloadUrl))).build();
            player.sendMessage((Component)downloadMessage);
            this.plugin.logResponse("Sent update notification to admin: " + player.getName());
        }
        catch (Exception e) {
            this.plugin.logError("Failed to send update notification to " + player.getName() + ": " + e.getMessage());
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.hasUpdatePermission(player)) {
            if (this.updateAvailable) {
                FoliaDetector.getScheduler((Plugin)this.plugin).runTaskLater(() -> this.sendUpdateNotification(player), 40L);
            } else if (this.latestVersion == null) {
                this.checkForUpdates().thenAccept(hasUpdate -> {
                    if (hasUpdate.booleanValue()) {
                        FoliaDetector.getScheduler((Plugin)this.plugin).runTaskLater(() -> this.sendUpdateNotification(player), 40L);
                    }
                });
            }
        }
    }
}

