/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.folia;

import com.nonxedy.nonchat.util.folia.FoliaScheduler;
import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class FoliaSchedulerImpl
implements FoliaScheduler {
    private final Plugin plugin;
    private final Object regionScheduler;
    private final Object entityScheduler;
    private final Object asyncScheduler;
    private final Object globalRegionScheduler;

    public FoliaSchedulerImpl(Plugin plugin) {
        this.plugin = plugin;
        try {
            Server server = plugin.getServer();
            Method getRegionScheduler = server.getClass().getMethod("getRegionScheduler", new Class[0]);
            this.regionScheduler = getRegionScheduler.invoke((Object)server, new Object[0]);
            Method getAsyncScheduler = server.getClass().getMethod("getAsyncScheduler", new Class[0]);
            this.asyncScheduler = getAsyncScheduler.invoke((Object)server, new Object[0]);
            Method getGlobalRegionScheduler = server.getClass().getMethod("getGlobalRegionScheduler", new Class[0]);
            this.globalRegionScheduler = getGlobalRegionScheduler.invoke((Object)server, new Object[0]);
            this.entityScheduler = null;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize Folia scheduler", e);
        }
    }

    @Override
    public BukkitTask runTask(Runnable task) {
        try {
            return this.findAndInvokeMethod(this.globalRegionScheduler, "run", task, 0L);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to run task on Folia", e);
        }
    }

    @Override
    public BukkitTask runTaskAsynchronously(Runnable task) {
        try {
            Method[] methods;
            for (Method method : methods = this.asyncScheduler.getClass().getMethods()) {
                String methodName = method.getName();
                if (!methodName.equals("runNow") && !methodName.equals("run") && !methodName.equals("submit") || method.getParameterCount() != 2) continue;
                try {
                    Object scheduledTask = method.invoke(this.asyncScheduler, this.plugin, task);
                    return this.wrapScheduledTask(scheduledTask);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.findAndInvokeMethod(this.asyncScheduler, "async", task, 0L);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to run async task on Folia", e);
        }
    }

    @Override
    public BukkitTask runTaskLater(Runnable task, long delay) {
        try {
            return this.findAndInvokeMethod(this.globalRegionScheduler, "delayed", task, delay);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to run delayed task on Folia", e);
        }
    }

    @Override
    public BukkitTask runTaskLaterAsynchronously(Runnable task, long delay) {
        try {
            return this.findAndInvokeMethod(this.asyncScheduler, "delayed", task, delay);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to run delayed async task on Folia", e);
        }
    }

    private BukkitTask findAndInvokeMethod(Object scheduler, String operationType, Runnable task, long delay) throws Exception {
        Method[] methods = scheduler.getClass().getMethods();
        BukkitTask result = this.trySpecificMethods(scheduler, operationType, task, delay, methods);
        if (result != null) {
            return result;
        }
        result = this.tryAnyMethod(scheduler, task, delay, methods);
        if (result != null) {
            return result;
        }
        if (operationType.contains("async")) {
            this.plugin.getLogger().fine("No async scheduling method found, executing task immediately");
            new Thread(task).start();
            return this.createImmediateTask();
        }
        this.plugin.getLogger().fine("No scheduling method found, executing task immediately");
        task.run();
        return this.createImmediateTask();
    }

    private BukkitTask createImmediateTask() {
        return new BukkitTask(){
            private volatile boolean cancelled = false;

            public int getTaskId() {
                return -1;
            }

            public Plugin getOwner() {
                return FoliaSchedulerImpl.this.plugin;
            }

            public boolean isSync() {
                return true;
            }

            public boolean isCancelled() {
                return this.cancelled;
            }

            public void cancel() {
                this.cancelled = true;
            }
        };
    }

    private BukkitTask trySpecificMethods(Object scheduler, String operationType, Runnable task, long delay, Method[] methods) {
        String[] possibleMethodNames;
        for (String methodName : possibleMethodNames = new String[]{"run", "execute", "submit", "schedule", "runDelayed", "runLater", "delay", "runAt", "scheduleDelayed", "runAfter", "runNow", "runAsync", "async", "timed", "repeating"}) {
            for (Method method : methods) {
                if (!method.getName().toLowerCase().contains(methodName.toLowerCase()) && !method.getName().toLowerCase().contains(operationType.toLowerCase())) continue;
                try {
                    Object[] args = this.tryInvokeMethod(method, this.plugin, task, delay);
                    if (args == null) continue;
                    Object scheduledTask = method.invoke(scheduler, args);
                    return this.wrapScheduledTask(scheduledTask);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private BukkitTask tryAnyMethod(Object scheduler, Runnable task, long delay, Method[] methods) {
        for (Method method : methods) {
            String methodName = method.getName().toLowerCase();
            if (methodName.contains("get") || methodName.contains("set") || methodName.contains("is") || methodName.contains("has") || methodName.contains("cancel") || methodName.contains("remove") || methodName.contains("equals") || methodName.contains("hashcode") || methodName.contains("tostring") || methodName.contains("notify") || methodName.contains("wait") || methodName.contains("class") || methodName.contains("register") || methodName.contains("unregister") || methodName.length() < 3 || !methodName.contains("run") && !methodName.contains("exec") && !methodName.contains("schedule") && !methodName.contains("task") && !methodName.contains("submit") && !methodName.contains("call") && !methodName.contains("invoke") && !methodName.contains("start")) continue;
            try {
                Object[] args = this.tryInvokeMethod(method, this.plugin, task, delay);
                if (args == null) continue;
                Object scheduledTask = method.invoke(scheduler, args);
                this.plugin.getLogger().info("Using fallback method: " + method.getName());
                return this.wrapScheduledTask(scheduledTask);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Object[] tryInvokeMethod(Method method, Plugin plugin, Runnable task, long delay) {
        Object[][] possibleArgs;
        Class<?>[] paramTypes = method.getParameterTypes();
        for (Object[] args : possibleArgs = new Object[][]{{plugin, task, delay}, {plugin, task}, {task, delay}, {task}, {plugin, task, delay, delay}, {plugin, task, null, delay}, {task, plugin, delay}, {delay, plugin, task}, {plugin, delay, task}, {task, delay, plugin}, {plugin, task, delay, delay, delay}, {plugin, task}, {task, delay}, {task, delay}, {plugin, task, delay}}) {
            if (args.length != paramTypes.length) continue;
            boolean typesMatch = true;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                if (paramTypes[i].isPrimitive()) {
                    if (args[i] instanceof Long && paramTypes[i] == Long.TYPE || args[i] instanceof Integer && paramTypes[i] == Integer.TYPE) continue;
                    typesMatch = false;
                    break;
                }
                if (paramTypes[i].isInstance(args[i])) continue;
                typesMatch = false;
                break;
            }
            if (!typesMatch) continue;
            return args;
        }
        return null;
    }

    @Override
    public BukkitTask runTaskTimer(final Runnable task, long delay, final long period) {
        try {
            Method[] methods;
            for (Method method : methods = this.globalRegionScheduler.getClass().getMethods()) {
                String methodName = method.getName();
                if (!methodName.equals("runAtFixedRate") && !methodName.equals("runTimer") && !methodName.equals("scheduleAtFixedRate") && !methodName.contains("FixedRate") || method.getParameterCount() != 4) continue;
                try {
                    Object scheduledTask = method.invoke(this.globalRegionScheduler, this.plugin, task, delay, period);
                    return this.wrapScheduledTask(scheduledTask);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                final Method runDelayed = this.globalRegionScheduler.getClass().getMethod("runDelayed", Plugin.class, Runnable.class, Long.TYPE);
                Runnable repeatingTask = new Runnable(){

                    @Override
                    public void run() {
                        task.run();
                        try {
                            runDelayed.invoke(FoliaSchedulerImpl.this.globalRegionScheduler, FoliaSchedulerImpl.this.plugin, this, period);
                        }
                        catch (Exception e) {
                            FoliaSchedulerImpl.this.plugin.getLogger().fine("Timer task stopped due to scheduling failure");
                        }
                    }
                };
                Object scheduledTask = runDelayed.invoke(this.globalRegionScheduler, this.plugin, repeatingTask, delay);
                return this.wrapScheduledTask(scheduledTask);
            }
            catch (Exception e) {
                task.run();
                return this.createImmediateTask();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to run timer task on Folia", e);
        }
    }

    @Override
    public BukkitTask runTaskTimerAsynchronously(final Runnable task, long delay, final long period) {
        try {
            Method[] methods;
            for (Method method : methods = this.asyncScheduler.getClass().getMethods()) {
                String methodName = method.getName();
                if (!methodName.equals("runAtFixedRate") && !methodName.equals("runTimer") && !methodName.equals("scheduleAtFixedRate") && !methodName.contains("FixedRate") || method.getParameterCount() != 4) continue;
                try {
                    Object scheduledTask = method.invoke(this.asyncScheduler, this.plugin, task, delay, period);
                    return this.wrapScheduledTask(scheduledTask);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                final Method runDelayed = this.asyncScheduler.getClass().getMethod("runDelayed", Plugin.class, Runnable.class, Long.TYPE);
                Runnable repeatingTask = new Runnable(){

                    @Override
                    public void run() {
                        task.run();
                        try {
                            runDelayed.invoke(FoliaSchedulerImpl.this.asyncScheduler, FoliaSchedulerImpl.this.plugin, this, period);
                        }
                        catch (Exception e) {
                            FoliaSchedulerImpl.this.plugin.getLogger().fine("Async timer task stopped due to scheduling failure");
                        }
                    }
                };
                Object scheduledTask = runDelayed.invoke(this.asyncScheduler, this.plugin, repeatingTask, delay);
                return this.wrapScheduledTask(scheduledTask);
            }
            catch (Exception e) {
                new Thread(task).start();
                return this.createImmediateTask();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to run async timer task on Folia", e);
        }
    }

    @Override
    public BukkitTask runTaskForEntity(Entity entity, Runnable task) {
        try {
            Method getScheduler = entity.getClass().getMethod("getScheduler", new Class[0]);
            Object entityScheduler = getScheduler.invoke((Object)entity, new Object[0]);
            Method run = entityScheduler.getClass().getMethod("run", Plugin.class, Runnable.class, Object.class, Long.TYPE);
            Object scheduledTask = run.invoke(entityScheduler, this.plugin, task, null, 0L);
            return this.wrapScheduledTask(scheduledTask);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to run task for entity on Folia", e);
        }
    }

    @Override
    public BukkitTask runTaskLaterForEntity(Entity entity, Runnable task, long delay) {
        try {
            Method getScheduler = entity.getClass().getMethod("getScheduler", new Class[0]);
            Object entityScheduler = getScheduler.invoke((Object)entity, new Object[0]);
            Method run = entityScheduler.getClass().getMethod("run", Plugin.class, Runnable.class, Object.class, Long.TYPE);
            Object scheduledTask = run.invoke(entityScheduler, this.plugin, task, null, delay);
            return this.wrapScheduledTask(scheduledTask);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to run delayed task for entity on Folia", e);
        }
    }

    @Override
    public BukkitTask runTaskAtLocation(Location location, Runnable task) {
        try {
            return this.findAndInvokeMethodWithLocation(this.regionScheduler, "location", task, 0L, location);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to run task at location on Folia", e);
        }
    }

    @Override
    public BukkitTask runTaskLaterAtLocation(Location location, Runnable task, long delay) {
        try {
            return this.findAndInvokeMethodWithLocation(this.regionScheduler, "delayed", task, delay, location);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to run delayed task at location on Folia", e);
        }
    }

    private BukkitTask findAndInvokeMethodWithLocation(Object scheduler, String operationType, Runnable task, long delay, Location location) throws Exception {
        Method[] methods = scheduler.getClass().getMethods();
        BukkitTask result = this.trySpecificMethodsWithLocation(scheduler, operationType, task, delay, location, methods);
        if (result != null) {
            return result;
        }
        result = this.tryAnyMethodWithLocation(scheduler, task, delay, location, methods);
        if (result != null) {
            return result;
        }
        if (operationType.contains("delayed")) {
            this.plugin.getLogger().warning("No delayed location method found, using global method");
            return this.runTaskLater(task, delay);
        }
        this.plugin.getLogger().warning("No location method found, using global method");
        return this.runTask(task);
    }

    private BukkitTask trySpecificMethodsWithLocation(Object scheduler, String operationType, Runnable task, long delay, Location location, Method[] methods) {
        String[] possibleMethodNames;
        for (String methodName : possibleMethodNames = new String[]{"run", "execute", "submit", "schedule", "runDelayed", "runLater", "delay", "runAt", "scheduleDelayed", "runAfter"}) {
            for (Method method : methods) {
                if (!method.getName().toLowerCase().contains(methodName.toLowerCase()) && !method.getName().toLowerCase().contains(operationType.toLowerCase())) continue;
                try {
                    Object[] args = this.tryInvokeMethodWithLocation(method, this.plugin, task, delay, location);
                    if (args == null) continue;
                    Object scheduledTask = method.invoke(scheduler, args);
                    return this.wrapScheduledTask(scheduledTask);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private BukkitTask tryAnyMethodWithLocation(Object scheduler, Runnable task, long delay, Location location, Method[] methods) {
        for (Method method : methods) {
            String methodName = method.getName().toLowerCase();
            if (methodName.contains("get") || methodName.contains("set") || methodName.contains("is") || methodName.contains("has") || methodName.contains("cancel") || methodName.contains("remove") || methodName.contains("equals") || methodName.contains("hashcode") || methodName.contains("tostring") || methodName.contains("notify") || methodName.contains("wait") || methodName.contains("class") || methodName.contains("register") || methodName.contains("unregister") || methodName.length() < 3 || !methodName.contains("run") && !methodName.contains("exec") && !methodName.contains("schedule") && !methodName.contains("task") && !methodName.contains("submit") && !methodName.contains("call") && !methodName.contains("invoke") && !methodName.contains("start")) continue;
            try {
                Object[] args = this.tryInvokeMethodWithLocation(method, this.plugin, task, delay, location);
                if (args == null) continue;
                Object scheduledTask = method.invoke(scheduler, args);
                this.plugin.getLogger().info("Using fallback location method: " + method.getName());
                return this.wrapScheduledTask(scheduledTask);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Object[] tryInvokeMethodWithLocation(Method method, Plugin plugin, Runnable task, long delay, Location location) {
        Object[][] possibleArgs;
        Class<?>[] paramTypes = method.getParameterTypes();
        for (Object[] args : possibleArgs = new Object[][]{{plugin, task, location}, {plugin, task, location, delay}, {task, location}, {task, location, delay}, {plugin, task, location, delay, delay}, {location, plugin, task}, {location, plugin, task, delay}, {plugin, location, task}, {plugin, location, task, delay}}) {
            if (args.length != paramTypes.length) continue;
            boolean typesMatch = true;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                if (paramTypes[i].isPrimitive()) {
                    if (args[i] instanceof Long && paramTypes[i] == Long.TYPE || args[i] instanceof Integer && paramTypes[i] == Integer.TYPE) continue;
                    typesMatch = false;
                    break;
                }
                if (paramTypes[i].isInstance(args[i])) continue;
                typesMatch = false;
                break;
            }
            if (!typesMatch) continue;
            return args;
        }
        return null;
    }

    @Override
    public BukkitTask runTaskForPlayer(Player player, Runnable task) {
        return this.runTaskForEntity((Entity)player, task);
    }

    @Override
    public BukkitTask runTaskLaterForPlayer(Player player, Runnable task, long delay) {
        return this.runTaskLaterForEntity((Entity)player, task, delay);
    }

    private BukkitTask wrapScheduledTask(final Object scheduledTask) {
        return new BukkitTask(){

            public int getTaskId() {
                try {
                    return (Integer)scheduledTask.getClass().getMethod("getTaskId", new Class[0]).invoke(scheduledTask, new Object[0]);
                }
                catch (Exception e) {
                    return -1;
                }
            }

            public Plugin getOwner() {
                return FoliaSchedulerImpl.this.plugin;
            }

            public boolean isSync() {
                return true;
            }

            public boolean isCancelled() {
                try {
                    return (Boolean)scheduledTask.getClass().getMethod("isCancelled", new Class[0]).invoke(scheduledTask, new Object[0]);
                }
                catch (Exception e) {
                    return false;
                }
            }

            public void cancel() {
                try {
                    scheduledTask.getClass().getMethod("cancel", new Class[0]).invoke(scheduledTask, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }
}

