/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat;

import com.nonxedy.nonchat.api.ChannelAPI;
import com.nonxedy.nonchat.command.impl.IgnoreCommand;
import com.nonxedy.nonchat.command.impl.SpyCommand;
import com.nonxedy.nonchat.core.BroadcastManager;
import com.nonxedy.nonchat.core.ChatManager;
import com.nonxedy.nonchat.core.MessageManager;
import com.nonxedy.nonchat.hook.DiscordSRVHook;
import com.nonxedy.nonchat.integration.DiscordSRVIntegration;
import com.nonxedy.nonchat.listener.ChatListener;
import com.nonxedy.nonchat.listener.ChatListenerFactory;
import com.nonxedy.nonchat.listener.DeathCoordinates;
import com.nonxedy.nonchat.listener.DeathListener;
import com.nonxedy.nonchat.listener.DiscordSRVListener;
import com.nonxedy.nonchat.listener.JoinQuitListener;
import com.nonxedy.nonchat.placeholders.NonchatExpansion;
import com.nonxedy.nonchat.service.ChatService;
import com.nonxedy.nonchat.service.CommandService;
import com.nonxedy.nonchat.service.ConfigService;
import com.nonxedy.nonchat.util.chat.packets.BubblePacketUtil;
import com.nonxedy.nonchat.util.core.debugging.Debugger;
import com.nonxedy.nonchat.util.core.updates.UpdateChecker;
import com.nonxedy.nonchat.util.integration.metrics.Metrics;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Nonchat
extends JavaPlugin {
    private ChatService chatService;
    private CommandService commandService;
    private ConfigService configService;
    private ChatManager chatManager;
    private MessageManager messageManager;
    private BroadcastManager broadcastManager;
    private SpyCommand spyCommand;
    private Debugger debugger;
    private ChatListener chatListener;
    private IgnoreCommand ignoreCommand;
    private DiscordSRVHook discordSRVHook;
    private DiscordSRVListener discordSRVListener;
    private DiscordSRVIntegration discordSRVIntegration;
    private Metrics metrics;
    private final Map<Player, List<ArmorStand>> bubbles = new HashMap<Player, List<ArmorStand>>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.saveResource("langs/messages_en.yml", false);
        this.saveResource("langs/messages_ru.yml", false);
        this.initializeServices();
        this.registerPlaceholders();
        this.registerListeners();
        this.setupIntegrations();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
            for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    if (!(entity instanceof ArmorStand)) continue;
                    entity.remove();
                }
            }
        }, 20L);
        Bukkit.getConsoleSender().sendMessage("\u00a7d[nonchat] \u00a7aplugin enabled");
    }

    private void initializeServices() {
        this.configService = new ConfigService(this);
        this.spyCommand = new SpyCommand(this, this.configService.getMessages(), this.configService.getConfig());
        this.ignoreCommand = new IgnoreCommand(this, this.configService.getMessages());
        this.chatManager = new ChatManager(this, this.configService.getConfig(), this.configService.getMessages());
        this.messageManager = new MessageManager(this, this.configService.getConfig(), this.configService.getMessages(), this.spyCommand);
        this.broadcastManager = new BroadcastManager(this, this.configService.getConfig());
        this.chatManager.setIgnoreCommand(this.ignoreCommand);
        this.messageManager.setIgnoreCommand(this.ignoreCommand);
        this.chatService = new ChatService(this.chatManager, this.messageManager, this.broadcastManager, this.configService.getConfig());
        this.commandService = new CommandService(this, this.chatService, this.configService);
        if (this.configService.getConfig().isDebug()) {
            this.debugger = new Debugger(this, this.configService.getConfig().getDebugLogRetentionDays());
            this.debugger.info("Core", "Services initialized successfully");
        }
    }

    private void registerListeners() {
        this.chatListener = ChatListenerFactory.createChatListener(this, this.chatManager, this.chatService);
        this.getServer().getPluginManager().registerEvents((Listener)this.chatListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new DeathListener(this.configService.getConfig()), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new DeathCoordinates(this.configService.getConfig()), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new JoinQuitListener(this.configService.getConfig()), (Plugin)this);
        if (this.debugger != null) {
            this.debugger.info("Events", "Event listeners registered successfully");
        }
    }

    private void registerPlaceholders() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new NonchatExpansion(this).register();
        }
    }

    private void setupIntegrations() {
        this.metrics = new Metrics((Plugin)this, 25786);
        this.discordSRVHook = new DiscordSRVHook(this);
        ChannelAPI.initialize(this);
        if (Bukkit.getPluginManager().getPlugin("DiscordSRV") != null) {
            this.discordSRVListener = new DiscordSRVListener(this);
            this.discordSRVIntegration = new DiscordSRVIntegration(this);
            this.getLogger().info("DiscordSRV integration enabled");
        }
        if (this.configService.getConfig().isUpdateCheckerEnabled()) {
            this.getLogger().info("Initializing update checker...");
            new UpdateChecker(this);
            if (this.debugger != null) {
                this.debugger.info("Updates", "Update checker initialized");
            }
        }
    }

    public void onDisable() {
        if (this.broadcastManager != null) {
            this.broadcastManager.stop();
        }
        if (this.commandService != null) {
            this.commandService.unregisterAll();
        }
        if (this.discordSRVListener != null) {
            this.discordSRVListener.shutdown();
        }
        if (this.discordSRVIntegration != null) {
            this.discordSRVIntegration.unregister();
        }
        Bukkit.getConsoleSender().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"[nonchat] ", (TextColor)TextColor.fromHexString((String)"#E088FF")))).append((Component)Component.text((String)"plugin disabled", (TextColor)TextColor.fromHexString((String)"#FF5252"))));
    }

    public void reloadConfig() {
        super.reloadConfig();
        if (this.configService != null) {
            this.configService.reload();
        }
        if (this.broadcastManager != null) {
            this.broadcastManager.reload();
        }
        if (this.commandService != null) {
            this.commandService.reloadCommands();
        }
    }

    public void reloadServices() {
        if (this.broadcastManager != null) {
            this.broadcastManager.stop();
        }
        if (this.configService != null) {
            this.configService.reload();
        }
        if (this.broadcastManager != null) {
            this.broadcastManager.reload();
        }
        if (this.commandService != null) {
            this.commandService.reloadCommands();
        }
        if (this.chatManager != null) {
            this.chatManager.reloadChannels();
        }
        if (this.configService != null && this.configService.getConfig().isDebug()) {
            if (this.debugger == null) {
                this.debugger = new Debugger(this, this.configService.getConfig().getDebugLogRetentionDays());
            }
        } else {
            this.debugger = null;
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        List<ArmorStand> playerBubbles = this.bubbles.remove(event.getPlayer());
        if (playerBubbles != null) {
            BubblePacketUtil.removeBubbles(playerBubbles);
        }
    }

    public SpyCommand getSpyCommand() {
        return this.spyCommand;
    }

    public IgnoreCommand getIgnoreCommand() {
        return this.ignoreCommand;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public void logCommand(String command, String[] args) {
        if (this.debugger != null) {
            this.debugger.debug("Commands", command + " Args: " + Arrays.toString(args));
        }
    }

    public void logResponse(String response) {
        if (this.debugger != null) {
            this.debugger.debug("API", "Response: " + response);
        }
    }

    public void logError(String error) {
        if (this.debugger != null) {
            this.debugger.error("System", "Error occurred", new Exception(error));
        }
    }

    public void logPlaceholder(String placeholder, String result) {
        if (this.debugger != null) {
            this.debugger.debug("Placeholders", placeholder + " -> " + result);
        }
    }

    public ChatManager getChatManager() {
        return this.chatManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }
}

