/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.chat.channel;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.api.Channel;
import com.nonxedy.nonchat.command.impl.IgnoreCommand;
import com.nonxedy.nonchat.service.ConfigService;
import com.nonxedy.nonchat.util.chat.filters.LinkDetector;
import com.nonxedy.nonchat.util.chat.formatting.HoverTextUtil;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import com.nonxedy.nonchat.util.items.detection.ItemDetector;
import com.nonxedy.nonchat.util.items.display.ItemDisplayUtil;
import com.nonxedy.nonchat.util.special.ping.PingDetector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BaseChannel
implements Channel {
    private final String id;
    private final String displayName;
    private final String format;
    private final char character;
    private final String sendPermission;
    private final String receivePermission;
    private final int radius;
    private final int cooldown;
    private final int minLength;
    private final int maxLength;
    private final HoverTextUtil hoverTextUtil;
    private boolean enabled;
    private static final Pattern mentionPattern = Pattern.compile("@(\\w+)");
    private IgnoreCommand ignoreCommand;
    private ConfigService configService;

    public BaseChannel(String id, String displayName, String format, char character, String sendPermission, String receivePermission, int radius, boolean enabled, HoverTextUtil hoverTextUtil, int cooldown, int minLength, int maxLength) {
        this.id = id;
        this.displayName = displayName;
        this.format = format;
        this.character = character;
        this.sendPermission = sendPermission;
        this.receivePermission = receivePermission;
        this.radius = radius;
        this.enabled = enabled;
        this.hoverTextUtil = hoverTextUtil;
        this.cooldown = cooldown;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public char getCharacter() {
        return this.character;
    }

    @Override
    public boolean hasTriggerCharacter() {
        return this.character != '\u0000';
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getSendPermission() {
        return this.sendPermission;
    }

    @Override
    public String getReceivePermission() {
        return this.receivePermission;
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public boolean isGlobal() {
        return this.radius == -1;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public boolean canSend(Player player) {
        return this.sendPermission == null || this.sendPermission.isEmpty() || player.hasPermission(this.sendPermission);
    }

    @Override
    public boolean canReceive(Player player) {
        return this.receivePermission == null || this.receivePermission.isEmpty() || player.hasPermission(this.receivePermission);
    }

    @Override
    public boolean isInRange(Player sender, Player recipient) {
        if (this.isGlobal()) {
            return true;
        }
        if (sender.getWorld() != recipient.getWorld()) {
            return false;
        }
        return sender.getLocation().distance(recipient.getLocation()) <= (double)this.radius;
    }

    @Override
    public Component formatMessage(Player player, String message) {
        String afterMessage;
        String baseFormat = this.getFormat();
        String[] formatParts = baseFormat.split("\\{message\\}");
        String beforeMessage = formatParts[0];
        String string = afterMessage = formatParts.length > 1 ? formatParts[1] : "";
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                beforeMessage = PlaceholderAPI.setPlaceholders((Player)player, (String)beforeMessage);
                afterMessage = PlaceholderAPI.setPlaceholders((Player)player, (String)afterMessage);
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "Error processing format placeholders: {0}", e.getMessage());
            }
        }
        Component beforeComponent = this.hoverTextUtil != null && beforeMessage.contains(player.getName()) ? this.createHoverableFormatPart(beforeMessage, player) : ColorUtil.parseComponent(beforeMessage);
        Component afterComponent = ColorUtil.parseComponent(afterMessage);
        Component finalMessage = beforeComponent.append(this.processMessageContent(player, message)).append(afterComponent);
        return finalMessage;
    }

    private Component createHoverableFormatPart(String formatPart, Player player) {
        String playerName = player.getName();
        int nameIndex = formatPart.indexOf(playerName);
        if (nameIndex == -1) {
            return ColorUtil.parseComponent(formatPart);
        }
        String beforeName = formatPart.substring(0, nameIndex);
        String afterName = formatPart.substring(nameIndex + playerName.length());
        Component beforeComp = ColorUtil.parseComponent(beforeName);
        Component afterComp = ColorUtil.parseComponent(afterName);
        Component hoverNameComp = this.hoverTextUtil.createHoverablePlayerName(player, playerName);
        return beforeComp.append(hoverNameComp).append(afterComp);
    }

    private Component processMessageContent(Player player, String message) {
        Nonchat nonchatPlugin;
        boolean globalEnabled;
        Plugin plugin = Bukkit.getPluginManager().getPlugin("nonchat");
        if (plugin instanceof Nonchat && !(globalEnabled = (nonchatPlugin = (Nonchat)plugin).getConfig().getBoolean("interactive-placeholders.enabled", true))) {
            return this.processMessageWithColorPermission(player, message);
        }
        boolean hasItem = message.toLowerCase().contains("[item]");
        boolean hasPing = message.toLowerCase().contains("[ping]");
        if (hasItem && hasPing) {
            return this.processBothPlaceholders(player, message);
        }
        if (hasItem) {
            return this.processItemPlaceholderWithColorPermission(player, message);
        }
        if (hasPing) {
            return this.processPingPlaceholderWithColorPermission(player, message);
        }
        return this.processMessageWithColorPermission(player, message);
    }

    private Component processMessageWithColorPermission(Player player, String message) {
        Component linkProcessed = LinkDetector.makeLinksClickable(message);
        if (!player.hasPermission("nonchat.color")) {
            String strippedMessage = ColorUtil.stripAllColors(message);
            return LinkDetector.makeLinksClickable(strippedMessage);
        }
        return linkProcessed;
    }

    private Component processItemPlaceholderWithColorPermission(Player player, String message) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("nonchat");
        boolean itemEnabled = true;
        if (plugin instanceof Nonchat) {
            Nonchat nonchatPlugin = (Nonchat)plugin;
            itemEnabled = nonchatPlugin.getConfig().getBoolean("interactive-placeholders.item-enabled", true);
        }
        if (!itemEnabled) {
            return this.processMessageWithColorPermission(player, message);
        }
        if (!player.hasPermission("nonchat.color")) {
            String messageWithoutColors = ColorUtil.stripAllColors(message);
            return ItemDetector.processItemPlaceholders(player, messageWithoutColors);
        }
        return ItemDetector.processItemPlaceholders(player, message);
    }

    private Component processPingPlaceholderWithColorPermission(Player player, String message) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("nonchat");
        boolean pingEnabled = true;
        if (plugin instanceof Nonchat) {
            Nonchat nonchatPlugin = (Nonchat)plugin;
            pingEnabled = nonchatPlugin.getConfig().getBoolean("interactive-placeholders.ping-enabled", true);
        }
        if (!pingEnabled) {
            return this.processMessageWithColorPermission(player, message);
        }
        if (!player.hasPermission("nonchat.color")) {
            String messageWithoutColors = ColorUtil.stripAllColors(message);
            return PingDetector.processPingPlaceholders(player, messageWithoutColors);
        }
        return PingDetector.processPingPlaceholders(player, message);
    }

    private Component processBothPlaceholders(Player player, String message) {
        boolean hasColorPermission;
        Plugin plugin = Bukkit.getPluginManager().getPlugin("nonchat");
        boolean itemEnabled = true;
        boolean pingEnabled = true;
        if (plugin instanceof Nonchat) {
            Nonchat nonchatPlugin = (Nonchat)plugin;
            itemEnabled = nonchatPlugin.getConfig().getBoolean("interactive-placeholders.item-enabled", true);
            pingEnabled = nonchatPlugin.getConfig().getBoolean("interactive-placeholders.ping-enabled", true);
        }
        String processedMessage = (hasColorPermission = player.hasPermission("nonchat.color")) ? message : ColorUtil.stripAllColors(message);
        TextComponent.Builder builder = Component.text();
        String[] parts = processedMessage.split("(?i)\\[(item|ping)\\]");
        Pattern pattern = Pattern.compile("(?i)\\[(item|ping)\\]");
        Matcher matcher = pattern.matcher(processedMessage);
        int partIndex = 0;
        while (matcher.find()) {
            if (partIndex < parts.length && !parts[partIndex].isEmpty()) {
                builder.append(LinkDetector.makeLinksClickable(parts[partIndex]));
            }
            ++partIndex;
            String placeholder = matcher.group().toLowerCase();
            if (placeholder.equals("[item]") && itemEnabled) {
                ItemStack heldItem = player.getInventory().getItemInMainHand();
                Component itemComponent = ItemDisplayUtil.createBracketedItemComponent(heldItem);
                builder.append(itemComponent);
                continue;
            }
            if (placeholder.equals("[ping]") && pingEnabled) {
                int ping = player.getPing();
                NamedTextColor color = ping < 100 ? NamedTextColor.GREEN : (ping < 300 ? NamedTextColor.GOLD : NamedTextColor.RED);
                builder.append(Component.text((String)(ping + "ms")).color((TextColor)color));
                continue;
            }
            builder.append((Component)Component.text((String)matcher.group()));
        }
        if (partIndex < parts.length && !parts[partIndex].isEmpty()) {
            builder.append(LinkDetector.makeLinksClickable(parts[partIndex]));
        }
        return builder.build();
    }

    public void setIgnoreCommand(IgnoreCommand ignoreCommand) {
        this.ignoreCommand = ignoreCommand;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }
}

