/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.listener;

import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;

public class DeathCoordinates
implements Listener {
    private final PluginConfig config;

    public DeathCoordinates(PluginConfig config) {
        this.config = config;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        Location deathLoc = player.getLocation();
        World.Environment dimension = deathLoc.getWorld().getEnvironment();
        if (this.config.isShowDeathCoordinatesEnabled()) {
            String coordsMessage = String.format("&fYou died in &d%s &fat coordinates: &fx:&d%d &fy:&d%d &fz:&d%d", this.formatDimension(dimension), deathLoc.getBlockX(), deathLoc.getBlockY(), deathLoc.getBlockZ());
            player.sendMessage(ColorUtil.parseComponent(coordsMessage));
        }
    }

    private String formatDimension(World.Environment dimension) {
        return switch (dimension) {
            case World.Environment.NORMAL -> "Overworld";
            case World.Environment.NETHER -> "Nether";
            case World.Environment.THE_END -> "The End";
            default -> dimension.toString();
        };
    }
}

