/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.listener;

import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;

public class DeathListener
implements Listener {
    private final PluginConfig config;

    public DeathListener(PluginConfig config) {
        this.config = config;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!this.config.isDeathMessagesEnabled()) {
            return;
        }
        Player player = event.getEntity();
        String deathFormat = this.config.getDeathFormat();
        if (deathFormat == null) {
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                deathFormat = PlaceholderAPI.setPlaceholders((Player)player, (String)deathFormat);
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "Error processing death message placeholders: {0}", e.getMessage());
            }
        }
        event.deathMessage(ColorUtil.parseComponent(deathFormat));
    }
}

