/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.chat.filters;

public class CapsFilter {
    private final boolean enabled;
    private final int maxCapsPercentage;
    private final int minLength;

    public CapsFilter(boolean enabled, int maxCapsPercentage, int minLength) {
        this.enabled = enabled;
        this.maxCapsPercentage = maxCapsPercentage;
        this.minLength = minLength;
    }

    public boolean shouldFilter(String message) {
        if (!this.enabled) {
            return false;
        }
        if (message.length() < this.minLength) {
            return false;
        }
        int capsCount = 0;
        for (char c : message.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            ++capsCount;
        }
        double percentage = (double)capsCount / (double)message.length() * 100.0;
        return percentage > (double)this.maxCapsPercentage;
    }

    public String filterMessage(String message) {
        return message.toLowerCase();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxCapsPercentage() {
        return this.maxCapsPercentage;
    }

    public int getMinLength() {
        return this.minLength;
    }
}

