/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.chat.formatting;

import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import com.nonxedy.nonchat.util.integration.external.IntegrationUtil;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class HoverTextUtil {
    private final List<String> hoverFormat;
    private final boolean enabled;
    private final boolean usePlaceholderAPI;

    public HoverTextUtil(List<String> format, boolean enabled) {
        this.hoverFormat = format;
        this.enabled = enabled;
        this.usePlaceholderAPI = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    public Component createHoverablePlayerName(Player player, String originalText) {
        if (!this.enabled) {
            return ColorUtil.parseComponent(originalText);
        }
        String hoverText = this.hoverFormat.stream().map(line -> this.processLine((String)line, player)).collect(Collectors.joining("\n"));
        Component nameComponent = ColorUtil.parseComponent(originalText);
        Component hoverComponent = ColorUtil.parseComponent(hoverText);
        return nameComponent.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComponent)).clickEvent(ClickEvent.suggestCommand((String)("/m " + player.getName())));
    }

    private String processLine(String text, Player player) {
        if (text == null) {
            return "";
        }
        String prefix = IntegrationUtil.getPlayerPrefix(player);
        String balance = IntegrationUtil.getBalance(player);
        String playtime = IntegrationUtil.getPlayTime(player);
        String processed = text.replace("{player}", player.getName()).replace("{level}", String.valueOf(player.getLevel())).replace("{prefix}", prefix != null ? prefix : "").replace("{playtime}", playtime != null ? playtime : "0h").replace("{balance}", balance != null ? balance : "0");
        if (this.usePlaceholderAPI) {
            try {
                processed = PlaceholderAPI.setPlaceholders((Player)player, (String)processed);
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "Error processing placeholder: {0}", e.getMessage());
            }
        }
        return ColorUtil.parseColor(processed);
    }
}

