/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.core.colors;

import com.nonxedy.nonchat.util.core.colors.LRUCache;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.entity.Player;

public class ColorUtil {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");
    private static final Pattern LEGACY_COLOR_PATTERN = Pattern.compile("&[0-9a-fklmnor]");
    private static final Pattern SECTION_COLOR_PATTERN = Pattern.compile("\u00a7[0-9a-fklmnor]");
    private static final Pattern MINIMESSAGE_PATTERN = Pattern.compile("<[^>]+>");
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final LRUCache<String, String> COLOR_CACHE = new LRUCache(1000);
    private static final Map<String, Component> COMPONENT_CACHE = Collections.synchronizedMap(new WeakHashMap());

    public static String parseColor(String message) {
        if (message == null) {
            return "";
        }
        String cached = COLOR_CACHE.get(message);
        if (cached != null) {
            return cached;
        }
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuilder buffer = new StringBuilder(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + group)).toString());
        }
        matcher.appendTail(buffer);
        String result = ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
        COLOR_CACHE.put(message, result);
        return result;
    }

    public static Component parseComponentCached(String message) {
        if (message == null || message.isEmpty()) {
            return Component.empty();
        }
        return COMPONENT_CACHE.computeIfAbsent(message, m -> {
            if (m.contains("<#") || m.contains("<gradient") || m.contains("<rainbow") || m.contains("<bold") || m.contains("<italic") || m.contains("<underlined") || m.contains("<strikethrough") || m.contains("<obfuscated") || m.contains("<reset") || m.contains("<color") || m.contains("<black") || m.contains("<dark_blue") || m.contains("<dark_green") || m.contains("<dark_aqua") || m.contains("<dark_red") || m.contains("<dark_purple") || m.contains("<gold") || m.contains("<gray") || m.contains("<dark_gray") || m.contains("<blue") || m.contains("<aqua") || m.contains("<red") || m.contains("<light_purple") || m.contains("<yellow") || m.contains("<white")) {
                return ColorUtil.parseMiniMessageComponent(ColorUtil.prepareMixedFormatMessage(m));
            }
            String legacyMessage = ColorUtil.parseColor(m);
            return LegacyComponentSerializer.legacySection().deserialize(legacyMessage);
        });
    }

    public static Component parseComponent(String message) {
        if (message != null && (message.contains("<#") || message.contains("<gradient") || message.contains("<rainbow") || message.contains("<bold") || message.contains("<italic") || message.contains("<underlined") || message.contains("<strikethrough") || message.contains("<obfuscated") || message.contains("<reset") || message.contains("<color") || message.contains("<black") || message.contains("<dark_blue") || message.contains("<dark_green") || message.contains("<dark_aqua") || message.contains("<dark_red") || message.contains("<dark_purple") || message.contains("<gold") || message.contains("<gray") || message.contains("<dark_gray") || message.contains("<blue") || message.contains("<aqua") || message.contains("<red") || message.contains("<light_purple") || message.contains("<yellow") || message.contains("<white"))) {
            return ColorUtil.parseMiniMessageComponent(message);
        }
        String legacyMessage = ColorUtil.parseColor(message);
        return LegacyComponentSerializer.legacySection().deserialize(legacyMessage);
    }

    public static Component parseComponent(String message, Player player) {
        if (player != null && !player.hasPermission("nonchat.color")) {
            return Component.text((String)ColorUtil.stripAllColors(message));
        }
        return ColorUtil.parseComponent(message);
    }

    public static Component parseMiniMessageComponent(String message) {
        if (message == null) {
            return Component.empty();
        }
        String preparedMessage = ColorUtil.prepareMixedFormatMessage(message);
        return MINI_MESSAGE.deserialize((Object)preparedMessage);
    }

    public static Component parseMiniMessageComponent(String message, Player player) {
        if (player != null && !player.hasPermission("nonchat.color")) {
            return Component.text((String)ColorUtil.stripAllColors(message));
        }
        return ColorUtil.parseMiniMessageComponent(message);
    }

    private static String prepareMixedFormatMessage(String message) {
        if (message == null) {
            return "";
        }
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuffer buffer = new StringBuffer(message.length() + 32);
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            matcher.appendReplacement(buffer, "<#" + hexColor + ">");
        }
        matcher.appendTail(buffer);
        String result = buffer.toString();
        result = result.replace("&0", "<black>");
        result = result.replace("&1", "<dark_blue>");
        result = result.replace("&2", "<dark_green>");
        result = result.replace("&3", "<dark_aqua>");
        result = result.replace("&4", "<dark_red>");
        result = result.replace("&5", "<dark_purple>");
        result = result.replace("&6", "<gold>");
        result = result.replace("&7", "<gray>");
        result = result.replace("&8", "<dark_gray>");
        result = result.replace("&9", "<blue>");
        result = result.replace("&a", "<green>");
        result = result.replace("&b", "<aqua>");
        result = result.replace("&c", "<red>");
        result = result.replace("&d", "<light_purple>");
        result = result.replace("&e", "<yellow>");
        result = result.replace("&f", "<white>");
        result = result.replace("\u00a70", "<black>");
        result = result.replace("\u00a71", "<dark_blue>");
        result = result.replace("\u00a72", "<dark_green>");
        result = result.replace("\u00a73", "<dark_aqua>");
        result = result.replace("\u00a74", "<dark_red>");
        result = result.replace("\u00a75", "<dark_purple>");
        result = result.replace("\u00a76", "<gold>");
        result = result.replace("\u00a77", "<gray>");
        result = result.replace("\u00a78", "<dark_gray>");
        result = result.replace("\u00a79", "<blue>");
        result = result.replace("\u00a7a", "<green>");
        result = result.replace("\u00a7b", "<aqua>");
        result = result.replace("\u00a7c", "<red>");
        result = result.replace("\u00a7d", "<light_purple>");
        result = result.replace("\u00a7e", "<yellow>");
        result = result.replace("\u00a7f", "<white>");
        result = result.replace("&l", "<bold>");
        result = result.replace("&m", "<strikethrough>");
        result = result.replace("&n", "<underlined>");
        result = result.replace("&o", "<italic>");
        result = result.replace("&k", "<obfuscated>");
        result = result.replace("&r", "<reset>");
        result = result.replace("\u00a7l", "<bold>");
        result = result.replace("\u00a7m", "<strikethrough>");
        result = result.replace("\u00a7n", "<underlined>");
        result = result.replace("\u00a7o", "<italic>");
        result = result.replace("\u00a7k", "<obfuscated>");
        result = result.replace("\u00a7r", "<reset>");
        return result;
    }

    public static String stripAllColors(String message) {
        if (message == null) {
            return "";
        }
        String result = message;
        result = HEX_PATTERN.matcher(result).replaceAll("");
        result = LEGACY_COLOR_PATTERN.matcher(result).replaceAll("");
        result = SECTION_COLOR_PATTERN.matcher(result).replaceAll("");
        result = MINIMESSAGE_PATTERN.matcher(result).replaceAll("");
        return result;
    }

    public static boolean hasColorCodes(String message) {
        if (message == null) {
            return false;
        }
        return HEX_PATTERN.matcher(message).find() || LEGACY_COLOR_PATTERN.matcher(message).find() || SECTION_COLOR_PATTERN.matcher(message).find() || MINIMESSAGE_PATTERN.matcher(message).find();
    }

    public static String processMessageWithPermission(String message, Player player) {
        if (player != null && !player.hasPermission("nonchat.color")) {
            return ColorUtil.stripAllColors(message);
        }
        return ColorUtil.parseColor(message);
    }
}

