/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.integration.external;

import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.user.User;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class IntegrationUtil {
    private static LuckPerms luckPerms;
    private static Economy economy;
    private static boolean placeholderAPIEnabled;

    public static void setupIntegrations() {
        IntegrationUtil.setupLuckPerms();
        IntegrationUtil.setupEconomy();
        placeholderAPIEnabled = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    private static void setupLuckPerms() {
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
        if (provider != null) {
            luckPerms = (LuckPerms)provider.getProvider();
        }
    }

    private static void setupEconomy() {
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (provider != null) {
            economy = (Economy)provider.getProvider();
        }
    }

    public static String getPlayerPrefix(Player player) {
        if (luckPerms != null) {
            User user = luckPerms.getUserManager().getUser(player.getUniqueId());
            return user != null ? user.getCachedData().getMetaData().getPrefix() : "";
        }
        return "";
    }

    public static String getBalance(Player player) {
        if (economy != null) {
            return String.format("%.2f", economy.getBalance((OfflinePlayer)player));
        }
        return "0";
    }

    public static String getPlayTime(Player player) {
        if (placeholderAPIEnabled) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)"%statistic_time_played%");
        }
        return "0h";
    }

    public static String processPlaceholders(Player player, String text) {
        if (placeholderAPIEnabled && player != null && text != null) {
            try {
                return PlaceholderAPI.setPlaceholders((Player)player, (String)text);
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "Error processing placeholder: {0}", e.getMessage());
                return text;
            }
        }
        return text;
    }
}

