/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.api;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.api.Channel;
import com.nonxedy.nonchat.api.MessageFilter;
import com.nonxedy.nonchat.api.MessageProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ChannelAPI {
    private static Nonchat plugin;
    private static final Map<String, List<MessageProcessor>> channelProcessors;
    private static final Map<String, List<MessageFilter>> channelFilters;

    public static void initialize(Nonchat instance) {
        plugin = instance;
    }

    public static Collection<Channel> getAllChannels() {
        return plugin.getChatManager().getChannelManager().getAllChannels();
    }

    public static Channel getChannel(String channelId) {
        return plugin.getChatManager().getChannelManager().getChannel(channelId);
    }

    public static Optional<Channel> getChannelOptional(String channelId) {
        return Optional.ofNullable(ChannelAPI.getChannel(channelId));
    }

    public static Channel getPlayerChannel(Player player) {
        return plugin.getChatManager().getPlayerChannel(player);
    }

    public static boolean isMessageForChannel(String message, String channelId) {
        return ChannelAPI.getChannelOptional(channelId).filter(Channel::isEnabled).filter(Channel::hasPrefix).map(channel -> message.startsWith(channel.getPrefix())).orElse(false);
    }

    public static List<Channel> findChannels(Predicate<Channel> predicate) {
        return ChannelAPI.getAllChannels().stream().filter(predicate).collect(Collectors.toList());
    }

    public static Optional<Channel> findChannel(Predicate<Channel> predicate) {
        return ChannelAPI.getAllChannels().stream().filter(predicate).findFirst();
    }

    public static List<Channel> getEnabledChannels() {
        return ChannelAPI.getAllChannels().stream().filter(Channel::isEnabled).collect(Collectors.toList());
    }

    public static List<Channel> getGlobalChannels() {
        return ChannelAPI.getAllChannels().stream().filter(Channel::isGlobal).collect(Collectors.toList());
    }

    public static List<Channel> getAccessibleChannels(Player player) {
        return ChannelAPI.getAllChannels().stream().filter(Channel::isEnabled).filter(channel -> channel.canSend(player)).collect(Collectors.toList());
    }

    public static List<Player> getPlayersWithAccess(String channelId) {
        Channel channel = ChannelAPI.getChannel(channelId);
        if (channel == null) {
            return Collections.emptyList();
        }
        return Bukkit.getOnlinePlayers().stream().filter(player -> channel.canSend((Player)player) || channel.canReceive((Player)player)).collect(Collectors.toList());
    }

    public static void registerMessageProcessor(String channelId, MessageProcessor processor) {
        Objects.requireNonNull(processor, "Processor cannot be null");
        channelProcessors.computeIfAbsent(channelId, k -> new ArrayList()).add(processor);
    }

    public static boolean unregisterMessageProcessor(String channelId, MessageProcessor processor) {
        if (!channelProcessors.containsKey(channelId)) {
            return false;
        }
        List<MessageProcessor> processors = channelProcessors.get(channelId);
        return processors.remove(processor);
    }

    public static List<MessageProcessor> getMessageProcessors(String channelId) {
        return channelProcessors.getOrDefault(channelId, Collections.emptyList());
    }

    public static void registerMessageFilter(String channelId, MessageFilter filter) {
        Objects.requireNonNull(filter, "Filter cannot be null");
        channelFilters.computeIfAbsent(channelId, k -> new ArrayList()).add(filter);
    }

    public static boolean unregisterMessageFilter(String channelId, MessageFilter filter) {
        if (!channelFilters.containsKey(channelId)) {
            return false;
        }
        List<MessageFilter> filters = channelFilters.get(channelId);
        return filters.remove(filter);
    }

    public static List<MessageFilter> getMessageFilters(String channelId) {
        return channelFilters.getOrDefault(channelId, Collections.emptyList());
    }

    public static String processMessage(Player player, String message, String channelId) {
        String result = message;
        for (MessageProcessor processor : ChannelAPI.getMessageProcessors(channelId)) {
            result = processor.process(player, result);
            if (result != null) continue;
            return null;
        }
        return result;
    }

    public static boolean shouldFilterMessage(Player player, String message, String channelId) {
        return ChannelAPI.getMessageFilters(channelId).stream().anyMatch(filter -> filter.shouldFilter(player, message));
    }

    static {
        channelProcessors = new HashMap<String, List<MessageProcessor>>();
        channelFilters = new HashMap<String, List<MessageFilter>>();
    }
}

