/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.chat.channel;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.api.Channel;
import com.nonxedy.nonchat.chat.channel.BaseChannel;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.util.AsyncConfigSaver;
import com.nonxedy.nonchat.util.chat.formatting.HoverTextUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChannelManager {
    private final Map<String, Channel> channels = new ConcurrentHashMap<String, Channel>();
    private final Map<Player, Channel> playerChannels = new ConcurrentHashMap<Player, Channel>();
    private final Map<Player, Long> lastMessageTimes = new ConcurrentHashMap<Player, Long>();
    private String defaultChannelId;
    private final PluginConfig config;
    private final AsyncConfigSaver asyncConfigSaver;

    public ChannelManager(Nonchat plugin, PluginConfig config) {
        this.config = config;
        this.asyncConfigSaver = new AsyncConfigSaver(plugin, config);
        this.loadChannels();
    }

    public void loadChannels() {
        this.channels.clear();
        ConfigurationSection channelsSection = this.config.getConfigurationSection("channels");
        if (channelsSection == null) {
            this.createDefaultChannels();
            return;
        }
        this.defaultChannelId = this.config.getString("default-channel", "global");
        HoverTextUtil hoverTextUtil = this.config.getHoverTextUtil();
        for (String channelId : channelsSection.getKeys(false)) {
            Object object;
            ConfigurationSection channelSection = channelsSection.getConfigurationSection(channelId);
            if (channelSection == null) continue;
            boolean enabled = channelSection.getBoolean("enabled", true);
            String displayName = channelSection.getString("display-name", channelId);
            String format = channelSection.getString("format", "{prefix}{sender}{suffix}: {message}");
            String prefix = channelSection.getString("character", "");
            if (prefix != null && !prefix.isEmpty()) {
                if (prefix.contains(" ")) {
                    Bukkit.getLogger().warning("Channel " + channelId + " has invalid prefix with whitespace. Prefix will be ignored.");
                    prefix = "";
                } else if (prefix.length() > 10) {
                    Bukkit.getLogger().warning("Channel " + channelId + " prefix too long (max 10 characters). Prefix will be truncated.");
                    prefix = prefix.substring(0, 10);
                }
            }
            String sendPermission = channelSection.getString("send-permission", "");
            String receivePermission = channelSection.getString("receive-permission", "");
            Object radiusObj = channelSection.get("radius");
            int radius = -1;
            String world = "";
            Objects.requireNonNull(radiusObj);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Integer.class}, (Object)object, n)) {
                case 0: {
                    String string = (String)object;
                    String radiusStr = string.toLowerCase().trim();
                    if (radiusStr.equals("world")) {
                        radius = -2;
                        world = "world";
                        break;
                    }
                    try {
                        radius = Integer.parseInt(radiusStr);
                    }
                    catch (NumberFormatException e) {
                        radius = -1;
                    }
                    break;
                }
                case 1: {
                    Integer integer = (Integer)object;
                    radius = integer;
                    break;
                }
            }
            int cooldown = channelSection.getInt("cooldown", 0);
            int minLength = channelSection.getInt("min-length", 0);
            int maxLength = channelSection.getInt("max-length", 256);
            BaseChannel channel = new BaseChannel(channelId, displayName, format, prefix, sendPermission, receivePermission, radius, world, enabled, hoverTextUtil, cooldown, minLength, maxLength);
            if (this.config.isDebug()) {
                Bukkit.getLogger().log(Level.INFO, "Loaded channel: {0}, max-length: {1}", new Object[]{channelId, maxLength});
            }
            this.channels.put(channelId, channel);
        }
        if (this.channels.isEmpty()) {
            this.createDefaultChannels();
        }
    }

    private void createDefaultChannels() {
        HoverTextUtil hoverTextUtil = this.config.getHoverTextUtil();
        BaseChannel globalChannel = new BaseChannel("global", "Global", "\u00a77(\u00a76G\u00a77)\u00a7r {prefix} \u00a7f{sender}\u00a7r {suffix}\u00a77: \u00a7f{message}", "!", "", "", -1, true, hoverTextUtil, 0, 0, 256);
        this.channels.put("global", globalChannel);
        BaseChannel localChannel = new BaseChannel("local", "Local", "\u00a77(\u00a76L\u00a77)\u00a7r {prefix} \u00a7f{sender}\u00a7r {suffix}\u00a77: \u00a7f{message}", "", "", "", 100, true, hoverTextUtil, 0, 0, 256);
        this.channels.put("local", localChannel);
        this.defaultChannelId = "local";
        this.saveChannelToConfig("global", globalChannel);
        this.saveChannelToConfig("local", localChannel);
        this.asyncConfigSaver.saveAsync("default-channel", this.defaultChannelId);
    }

    public boolean isPrefixUnique(String prefix, String excludeChannelId) {
        if (prefix == null || prefix.isEmpty()) {
            return true;
        }
        return this.channels.values().stream().filter(channel -> excludeChannelId == null || !channel.getId().equals(excludeChannelId)).filter(Channel::hasPrefix).noneMatch(channel -> channel.getPrefix().equals(prefix));
    }

    public Channel createChannel(String channelId, String displayName, String format, String prefix, String sendPermission, String receivePermission, int radius, int cooldown, int minLength, int maxLength) {
        if (this.channels.containsKey(channelId)) {
            return null;
        }
        if (!(channelId = channelId.toLowerCase()).matches("^[a-z0-9-]+$")) {
            return null;
        }
        if (prefix != null && !prefix.isEmpty()) {
            if (prefix.contains(" ")) {
                return null;
            }
            if (prefix.length() > 10) {
                return null;
            }
            if (!this.isPrefixUnique(prefix, null)) {
                return null;
            }
        }
        if (prefix == null) {
            prefix = "";
        }
        BaseChannel channel = new BaseChannel(channelId, displayName, format, prefix, sendPermission, receivePermission, radius, "", true, this.config.getHoverTextUtil(), cooldown, minLength, maxLength);
        this.channels.put(channelId, channel);
        this.saveChannelToConfig(channelId, channel);
        this.asyncConfigSaver.saveNow();
        return channel;
    }

    public boolean updateChannel(String channelId, String displayName, String format, String prefix, String sendPermission, String receivePermission, Integer radius, Boolean enabled, Integer cooldown, Integer minLength, Integer maxLength) {
        String finalPrefix;
        Channel existingChannel = this.getChannel(channelId);
        if (existingChannel == null) {
            return false;
        }
        String string = finalPrefix = prefix != null ? prefix : existingChannel.getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            if (prefix.contains(" ")) {
                return false;
            }
            if (prefix.length() > 10) {
                return false;
            }
            if (!this.isPrefixUnique(prefix, channelId)) {
                return false;
            }
        }
        BaseChannel updatedChannel = new BaseChannel(channelId, displayName != null ? displayName : existingChannel.getDisplayName(), format != null ? format : existingChannel.getFormat(), finalPrefix, sendPermission != null ? sendPermission : existingChannel.getSendPermission(), receivePermission != null ? receivePermission : existingChannel.getReceivePermission(), radius != null ? radius.intValue() : existingChannel.getRadius(), existingChannel.getWorld(), enabled != null ? enabled.booleanValue() : existingChannel.isEnabled(), this.config.getHoverTextUtil(), cooldown != null ? cooldown.intValue() : existingChannel.getCooldown(), minLength != null ? minLength.intValue() : existingChannel.getMinLength(), maxLength != null ? maxLength.intValue() : existingChannel.getMaxLength());
        this.channels.put(channelId, updatedChannel);
        this.saveChannelToConfig(channelId, updatedChannel);
        this.asyncConfigSaver.saveNow();
        return true;
    }

    public boolean deleteChannel(String channelId) {
        if (channelId.equals(this.defaultChannelId)) {
            return false;
        }
        if (!this.channels.containsKey(channelId)) {
            return false;
        }
        this.channels.remove(channelId);
        this.config.set("channels." + channelId, null);
        this.asyncConfigSaver.saveNow();
        Channel defaultChannel = this.getDefaultChannel();
        for (Player player : this.playerChannels.keySet()) {
            if (!this.playerChannels.get(player).getId().equals(channelId)) continue;
            this.playerChannels.put(player, defaultChannel);
        }
        return true;
    }

    public boolean setDefaultChannel(String channelId) {
        Channel channel = this.getChannel(channelId);
        if (channel == null || !channel.isEnabled()) {
            return false;
        }
        this.defaultChannelId = channelId;
        this.config.set("default-channel", channelId);
        this.asyncConfigSaver.saveNow();
        return true;
    }

    private void saveChannelToConfig(String channelId, Channel channel) {
        String basePath = "channels." + channelId + ".";
        this.config.set(basePath + "enabled", channel.isEnabled());
        this.config.set(basePath + "display-name", channel.getDisplayName());
        this.config.set(basePath + "format", channel.getFormat());
        this.config.set(basePath + "character", channel.hasPrefix() ? channel.getPrefix() : "");
        this.config.set(basePath + "send-permission", channel.getSendPermission());
        this.config.set(basePath + "receive-permission", channel.getReceivePermission());
        if (channel.isWorldSpecific()) {
            this.config.set(basePath + "radius", "world");
        } else {
            this.config.set(basePath + "radius", channel.getRadius());
        }
        this.config.set(basePath + "cooldown", channel.getCooldown());
        this.config.set(basePath + "min-length", channel.getMinLength());
        this.config.set(basePath + "max-length", channel.getMaxLength());
    }

    @Nullable
    public Channel getChannel(String id) {
        return this.channels.get(id);
    }

    @NotNull
    public Channel getDefaultChannel() {
        Channel defaultChannel = this.channels.get(this.defaultChannelId);
        if (defaultChannel == null) {
            Optional<Channel> any = this.channels.values().stream().findFirst();
            return any.orElseThrow(() -> new IllegalStateException("No channels available"));
        }
        return defaultChannel;
    }

    @NotNull
    public Collection<Channel> getAllChannels() {
        return this.channels.values();
    }

    @NotNull
    public Collection<Channel> getEnabledChannels() {
        return this.channels.values().stream().filter(Channel::isEnabled).collect(Collectors.toList());
    }

    @NotNull
    public Collection<Channel> getGlobalChannels() {
        return this.channels.values().stream().filter(Channel::isGlobal).collect(Collectors.toList());
    }

    @NotNull
    public Collection<Channel> getLocalChannels() {
        return this.channels.values().stream().filter(channel -> !channel.isGlobal()).collect(Collectors.toList());
    }

    @NotNull
    public Collection<Channel> getChannelsForPlayer(Player player) {
        return this.channels.values().stream().filter(Channel::isEnabled).filter(channel -> channel.canSend(player)).collect(Collectors.toList());
    }

    @NotNull
    public Channel getChannelForMessage(String message) {
        if (message == null || message.isEmpty()) {
            return this.getDefaultChannel();
        }
        return this.channels.values().stream().filter(Channel::isEnabled).filter(Channel::hasPrefix).filter(channel -> message.startsWith(channel.getPrefix())).sorted((c1, c2) -> Integer.compare(c2.getPrefix().length(), c1.getPrefix().length())).findFirst().orElse(this.getDefaultChannel());
    }

    public Optional<Channel> findChannelByPrefix(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return Optional.empty();
        }
        return this.channels.values().stream().filter(Channel::isEnabled).filter(Channel::hasPrefix).filter(channel -> channel.getPrefix().equals(prefix)).findFirst();
    }

    public boolean setPlayerChannel(Player player, String channelId) {
        Channel channel = this.getChannel(channelId);
        if (channel != null && channel.isEnabled()) {
            this.playerChannels.put(player, channel);
            return true;
        }
        return false;
    }

    @NotNull
    public Channel getPlayerChannel(Player player) {
        return this.playerChannels.getOrDefault(player, this.getDefaultChannel());
    }

    public void removePlayerChannel(Player player) {
        this.playerChannels.remove(player);
    }

    public void cleanupPlayer(Player player) {
        this.playerChannels.remove(player);
        this.lastMessageTimes.remove(player);
    }

    public void recordMessageSent(Player player) {
        this.lastMessageTimes.entrySet().removeIf(entry -> !((Player)entry.getKey()).isOnline());
        this.lastMessageTimes.put(player, System.currentTimeMillis());
    }

    public boolean canSendMessage(Player player, Channel channel) {
        if (channel.getCooldown() <= 0 || player.hasPermission("nonchat.bypass.cooldown")) {
            return true;
        }
        Long lastMessageTime = this.lastMessageTimes.get(player);
        if (lastMessageTime == null) {
            return true;
        }
        long cooldownMillis = (long)channel.getCooldown() * 1000L;
        long timeSinceLastMessage = System.currentTimeMillis() - lastMessageTime;
        return timeSinceLastMessage >= cooldownMillis;
    }

    public int getRemainingCooldown(Player player, Channel channel) {
        if (channel.getCooldown() <= 0 || player.hasPermission("nonchat.bypass.cooldown")) {
            return 0;
        }
        Long lastMessageTime = this.lastMessageTimes.get(player);
        if (lastMessageTime == null) {
            return 0;
        }
        long cooldownMillis = (long)channel.getCooldown() * 1000L;
        long timeSinceLastMessage = System.currentTimeMillis() - lastMessageTime;
        if (timeSinceLastMessage >= cooldownMillis) {
            return 0;
        }
        int remainingSeconds = (int)((cooldownMillis - timeSinceLastMessage) / 1000L);
        return remainingSeconds > 0 ? remainingSeconds : 1;
    }
}

