/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.command.impl;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ClearCommand
implements CommandExecutor,
TabCompleter {
    private final PluginMessages messages;
    private final Nonchat plugin;
    private static final int CLEAR_LINES = 100;

    public ClearCommand(PluginMessages messages, Nonchat plugin) {
        this.messages = messages;
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        this.plugin.logCommand(command.getName(), args);
        if (!this.hasPermission(sender)) {
            return true;
        }
        this.clearChat();
        this.sendClearNotification();
        return true;
    }

    private boolean hasPermission(CommandSender sender) {
        if (!sender.hasPermission("nonchat.clear")) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
            this.plugin.logError("Player attempted to clear chat without permission");
            return false;
        }
        return true;
    }

    private void clearChat() {
        try {
            TextComponent emptyLine = Component.empty();
            for (Player player : Bukkit.getOnlinePlayers()) {
                for (int i = 0; i < 100; ++i) {
                    player.sendMessage((Component)emptyLine);
                }
            }
            this.plugin.logResponse("Chat cleared successfully");
        }
        catch (Exception e) {
            this.plugin.logError("Failed to clear chat: " + e.getMessage());
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendMessage(Component.text((String)"Failed to clear chat").color((TextColor)NamedTextColor.RED));
            }
        }
    }

    private void sendClearNotification() {
        Bukkit.broadcast((Component)ColorUtil.parseComponentCached(this.messages.getString("chat-cleared")));
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("nonchat.clear")) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

