/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.command.impl;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MeCommand
implements CommandExecutor,
TabCompleter {
    private final Nonchat plugin;
    private final PluginConfig config;
    private final PluginMessages messages;

    public MeCommand(Nonchat plugin, PluginConfig config, PluginMessages messages) {
        this.plugin = plugin;
        this.config = config;
        this.messages = messages;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        this.plugin.logCommand(command.getName(), args);
        if (!this.validateCommandUsage(sender)) {
            return true;
        }
        try {
            this.broadcastMeMessage(sender, args);
        }
        catch (Exception e) {
            this.handleError(sender, e);
        }
        return true;
    }

    private boolean validateCommandUsage(CommandSender sender) {
        if (!this.config.isMeCommandEnabled()) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("command-disabled")));
            this.plugin.logError("Me command is disabled");
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("player-only")));
            this.plugin.logError("Me command used by non-player");
            return false;
        }
        if (!sender.hasPermission("nonchat.me")) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
            this.plugin.logError("No permission for me command: " + sender.getName());
            return false;
        }
        return true;
    }

    private void broadcastMeMessage(CommandSender sender, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("invalid-usage-me")));
            this.plugin.logError("Empty me command message from: " + sender.getName());
            return;
        }
        String message = String.join((CharSequence)" ", args);
        String formattedMessage = this.config.getMeFormat().replace("{message}", message);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                formattedMessage = PlaceholderAPI.setPlaceholders((Player)((Player)sender), (String)formattedMessage);
            }
            catch (Exception e) {
                this.plugin.logError("Failed to process PlaceholderAPI placeholders for me command: " + e.getMessage());
            }
        }
        this.plugin.getServer().broadcast(ColorUtil.parseComponent(formattedMessage));
        this.plugin.logResponse("Me command executed: " + sender.getName() + " - " + message);
    }

    private void handleError(CommandSender sender, Exception e) {
        sender.sendMessage(ColorUtil.parseComponentCached("&cAn error occurred while executing the command"));
        this.plugin.logError("Me command error: " + e.getMessage());
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("nonchat.me")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            List<String> suggestions = Arrays.asList("is jumping");
            return suggestions.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

