/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.config;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.libs.snakeyaml.error.YAMLException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class DeathConfig {
    private final File configFile;
    private final Logger logger;
    private final Nonchat plugin;
    private FileConfiguration config;

    public DeathConfig(File dataFolder, Logger logger, Nonchat plugin) {
        this.configFile = new File(dataFolder, "deaths.yml");
        this.logger = logger;
        this.plugin = plugin;
    }

    public void load() {
        try {
            boolean fileExisted = this.configFile.exists();
            this.saveDefaultConfig();
            if (!fileExisted) {
                this.logger.info("Created default deaths.yml configuration file");
            }
            this.setupConfigFile(true);
            this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
            if (this.config == null) {
                throw new IllegalStateException("Configuration loaded as null");
            }
            this.logger.info("Death messages configuration loaded successfully");
        }
        catch (YAMLException e) {
            this.logger.log(Level.SEVERE, "YAML syntax error in deaths.yml: " + e.getMessage(), e);
            this.config = new YamlConfiguration();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to load deaths.yml: " + e.getMessage(), e);
            this.config = new YamlConfiguration();
        }
    }

    private void saveDefaultConfig() {
        if (!this.configFile.exists()) {
            try {
                this.configFile.getParentFile().mkdirs();
                this.plugin.saveResource("deaths.yml", false);
                this.logger.info("Created default deaths.yml");
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Failed to create default deaths.yml: " + e.getMessage(), e);
            }
        }
    }

    public boolean isEnabled() {
        return this.config.getBoolean("settings.enabled", true);
    }

    public boolean useFallback() {
        return this.config.getBoolean("settings.use-fallback", true);
    }

    public boolean isDebugEnabled() {
        return this.config.getBoolean("settings.debug", false);
    }

    public boolean showCoordinates() {
        return this.config.getBoolean("settings.show-coordinates", true);
    }

    @NotNull
    public FileConfiguration getConfig() {
        return this.config;
    }

    @NotNull
    public File getConfigFile() {
        return this.configFile;
    }

    public void save() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Failed to save deaths.yml: " + e.getMessage(), e);
        }
    }

    public void reload() {
        this.load();
    }

    @NotNull
    public String getUnknownPlaceholder() {
        return this.config.getString("placeholders.unknown", "Unknown");
    }

    @NotNull
    public String getNonePlaceholder() {
        return this.config.getString("placeholders.none", "None");
    }

    @NotNull
    public String getUnknownEntityPlaceholder() {
        return this.config.getString("placeholders.unknown-entity", "Something");
    }

    @NotNull
    public String getUnknownPlayerPlaceholder() {
        return this.config.getString("placeholders.unknown-player", "Someone");
    }

    public boolean isIndirectTrackingEnabled() {
        return this.config.getBoolean("indirect-deaths.enabled", true);
    }

    public int getTrackingWindow() {
        int window = this.config.getInt("indirect-deaths.tracking-window", 10);
        if (window < 5) {
            this.logger.log(Level.WARNING, "Indirect death tracking window is too low ({0}s). Using minimum value of 5 seconds.", window);
            return 5;
        }
        if (window > 60) {
            this.logger.log(Level.WARNING, "Indirect death tracking window is too high ({0}s). Using maximum value of 60 seconds.", window);
            return 60;
        }
        return window;
    }

    public double getMinimumDamage() {
        double damage = this.config.getDouble("indirect-deaths.minimum-damage", 1.0);
        if (damage < 0.5) {
            this.logger.log(Level.WARNING, "Indirect death minimum damage is too low ({0} hearts). Using minimum value of 0.5 hearts.", damage);
            return 0.5;
        }
        if (damage > 20.0) {
            this.logger.log(Level.WARNING, "Indirect death minimum damage is too high ({0} hearts). Using maximum value of 20.0 hearts.", damage);
            return 20.0;
        }
        return damage;
    }

    public boolean isTrackMelee() {
        return this.config.getBoolean("indirect-deaths.track-melee", true);
    }

    public boolean isTrackProjectile() {
        return this.config.getBoolean("indirect-deaths.track-projectile", true);
    }

    public boolean isTrackExplosion() {
        return this.config.getBoolean("indirect-deaths.track-explosion", true);
    }

    @NotNull
    public List<String> getTrackedCauses() {
        List causes = this.config.getStringList("indirect-deaths.track-causes");
        if (causes.isEmpty()) {
            return List.of("FALL", "VOID", "LAVA", "DROWNING", "FIRE", "FIRE_TICK", "SUFFOCATION", "CONTACT");
        }
        return causes;
    }

    private void setupConfigFile(boolean backup) {
        block36: {
            try {
                YamlConfiguration defaultConfig;
                YamlConfiguration currentConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
                try (InputStream resourceStream = this.plugin.getResource("deaths.yml");){
                    if (resourceStream == null) {
                        this.logger.log(Level.WARNING, "Could not load default deaths.yml from plugin resources");
                        return;
                    }
                    defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
                }
                boolean hasChanges = false;
                int keysAdded = 0;
                for (String key : defaultConfig.getKeys(true)) {
                    if (currentConfig.contains(key) || defaultConfig.isConfigurationSection(key) || !this.shouldAddMissingKey(key, (FileConfiguration)currentConfig)) continue;
                    currentConfig.set(key, defaultConfig.get(key));
                    hasChanges = true;
                    ++keysAdded;
                    this.logger.log(Level.INFO, "Added missing configuration key: {0}", key);
                }
                if (hasChanges && backup) {
                    this.createBackup();
                }
                if (hasChanges) {
                    List<String> templateAsList = this.readResourceToList("deaths.yml");
                    HashMap<Integer, FileLine> templateLines = this.processFileLines(templateAsList);
                    StringBuilder builder = new StringBuilder();
                    HashMap<Integer, String> headers = new HashMap<Integer, String>();
                    int templatePositions = templateLines.size() + 1;
                    for (int pos = 1; pos < templatePositions; ++pos) {
                        String header;
                        int i;
                        FileLine fileLine = templateLines.get(pos);
                        if (fileLine == null) continue;
                        String line = fileLine.getLine();
                        if (!(fileLine.isValue() || fileLine.isHeader() || fileLine.isList())) {
                            builder.append(line).append("\n");
                            continue;
                        }
                        int spaces = 0;
                        for (char c : line.toCharArray()) {
                            if (c != ' ') break;
                            ++spaces;
                        }
                        int point = spaces / 2;
                        String identifier = line.substring(spaces).split(":")[0];
                        if (fileLine.isHeader()) {
                            headers.put(point, identifier);
                        }
                        if (fileLine.isValue()) {
                            StringBuilder path = new StringBuilder();
                            for (i = 0; i <= point - 1; ++i) {
                                header = (String)headers.get(i);
                                if (header == null) continue;
                                path.append(header).append(".");
                            }
                            path.append(identifier);
                            for (i = 0; i < spaces; ++i) {
                                builder.append(" ");
                            }
                            builder.append(identifier).append(": ");
                            Object value = currentConfig.get(path.toString());
                            if (value instanceof String) {
                                String string = (String)value;
                                String stringValue = string.replace("\n", "\\n");
                                builder.append("\"").append(stringValue).append("\"\n");
                                continue;
                            }
                            builder.append(value).append("\n");
                            continue;
                        }
                        if (fileLine.isList()) {
                            StringBuilder path = new StringBuilder();
                            for (i = 0; i <= point - 1; ++i) {
                                header = (String)headers.get(i);
                                if (header == null) continue;
                                path.append(header).append(".");
                            }
                            path.append(identifier);
                            for (i = 0; i < spaces; ++i) {
                                builder.append(" ");
                            }
                            builder.append(identifier).append(":");
                            List value = currentConfig.getStringList(path.toString());
                            if (value.isEmpty()) {
                                builder.append(" []\n");
                                continue;
                            }
                            builder.append("\n");
                            for (String listLine : value) {
                                for (int i2 = 0; i2 < spaces + 2; ++i2) {
                                    builder.append(" ");
                                }
                                String escapedListLine = listLine.replace("\n", "\\n");
                                boolean useSingleQuotes = escapedListLine.contains("\\");
                                String quote = useSingleQuotes ? "'" : "\"";
                                builder.append("- ").append(quote).append(escapedListLine).append(quote).append("\n");
                            }
                            continue;
                        }
                        builder.append(line).append("\n");
                    }
                    try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.configFile));){
                        writer.write(builder.toString());
                        writer.flush();
                    }
                    this.logger.info("Deaths.yml updated successfully with " + keysAdded + " new configuration option(s)");
                    if (backup) {
                        this.logger.info("A backup of your previous deaths.yml was created in the 'backups' folder");
                    }
                    break block36;
                }
                this.logger.info("Deaths.yml is up to date, no changes needed");
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Failed to update deaths.yml configuration: " + e.getMessage(), e);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Unexpected error during deaths.yml auto-update: " + e.getMessage(), e);
            }
        }
    }

    private void createBackup() {
        try {
            File backupDir = new File(this.plugin.getDataFolder(), "backups");
            if (!backupDir.exists()) {
                backupDir.mkdirs();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String timestamp = dateFormat.format(new Date());
            File backupFile = new File(backupDir, "deaths_" + timestamp + ".yml.backup");
            try (BufferedReader reader = new BufferedReader(new FileReader(this.configFile));
                 BufferedWriter writer = new BufferedWriter(new FileWriter(backupFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            this.logger.info("Created deaths.yml backup: " + backupFile.getName());
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Failed to create deaths.yml backup: " + e.getMessage(), e);
        }
    }

    private boolean shouldAddMissingKey(String key, FileConfiguration currentConfig) {
        if (!key.contains(".")) {
            return true;
        }
        String[] parts = key.split("\\.");
        String topLevelSection = parts[0];
        if (!this.hasAnyKeysInSection(currentConfig, topLevelSection)) {
            return true;
        }
        return true;
    }

    private boolean hasAnyKeysInSection(FileConfiguration config, String sectionName) {
        if (!config.contains(sectionName)) {
            return false;
        }
        Set allKeys = config.getKeys(true);
        for (String existingKey : allKeys) {
            if (!existingKey.startsWith(sectionName + ".") && !existingKey.equals(sectionName)) continue;
            return true;
        }
        return false;
    }

    private List<String> readFileToList(File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    private List<String> readResourceToList(String resourcePath) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (InputStream resource = this.plugin.getResource(resourcePath);
             BufferedReader reader = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    private HashMap<Integer, FileLine> processFileLines(List<String> fileLines) {
        HashMap<Integer, FileLine> processedLines = new HashMap<Integer, FileLine>();
        int positions = 1;
        for (int i = 0; i < fileLines.size(); ++i) {
            String line = fileLines.get(i);
            if (this.isListContent(line)) continue;
            if (!line.isEmpty() && !this.isComment(line) && line.contains(":")) {
                String[] split = line.split(":");
                boolean isValue = split.length > 1 && !this.isComment(split[1]);
                boolean isHeader = split.length == 1 || this.isComment(split[1]);
                boolean isList = isHeader && i + 1 < fileLines.size() && this.isListContent(fileLines.get(i + 1));
                processedLines.put(positions, new FileLine(line, isValue, isHeader, isList));
                ++positions;
                continue;
            }
            processedLines.put(positions, new FileLine(line, false, false, false));
            ++positions;
        }
        return processedLines;
    }

    private boolean isComment(String s) {
        return s.replace(" ", "").startsWith("#");
    }

    private boolean isListContent(String s) {
        return s.replace(" ", "").startsWith("-");
    }

    private static class FileLine {
        private final String line;
        private final boolean isValue;
        private final boolean isHeader;
        private final boolean isList;

        public FileLine(String line, boolean isValue, boolean isHeader, boolean isList) {
            this.line = line;
            this.isValue = isValue;
            this.isHeader = isHeader;
            this.isList = isList;
        }

        public String getLine() {
            return this.line;
        }

        public boolean isValue() {
            return this.isValue;
        }

        public boolean isHeader() {
            return this.isHeader;
        }

        public boolean isList() {
            return this.isList;
        }
    }
}

