/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.config;

import com.nonxedy.nonchat.config.DeathConfig;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import com.nonxedy.nonchat.util.core.debugging.Debugger;
import com.nonxedy.nonchat.util.death.DamageType;
import com.nonxedy.nonchat.util.death.DeathMessage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.configuration.ConfigurationSection;

public class DeathMessageLoader {
    private final File deathsFile;
    private final Debugger debugger;
    private final DeathConfig deathConfig;

    public DeathMessageLoader(File dataFolder, Debugger debugger, DeathConfig deathConfig) {
        this.deathsFile = new File(dataFolder, "deaths.yml");
        this.debugger = debugger;
        this.deathConfig = deathConfig;
    }

    public Map<String, List<DeathMessage>> loadAllMessages() {
        HashMap<String, List<DeathMessage>> messages = new HashMap<String, List<DeathMessage>>();
        try {
            if (!this.deathsFile.exists()) {
                this.debugger.warn("DeathMessageLoader", "deaths.yml not found at " + this.deathsFile.getAbsolutePath() + ". Creating default file...");
                this.createDefaultFile();
                this.deathConfig.reload();
            }
            if (this.deathConfig.getConfig() == null) {
                this.debugger.error("DeathMessageLoader", "Death configuration is null, cannot load messages", null);
                return messages;
            }
            ConfigurationSection messagesSection = this.deathConfig.getConfig().getConfigurationSection("messages");
            if (messagesSection == null) {
                this.debugger.warn("DeathMessageLoader", "No 'messages' section found in deaths.yml at " + this.deathsFile.getAbsolutePath());
                this.debugger.warn("DeathMessageLoader", "Please ensure the file has a 'messages:' section with death cause configurations");
                return messages;
            }
            int totalLoaded = 0;
            int totalSkipped = 0;
            int unknownCauses = 0;
            int emptyVariants = 0;
            for (String causeKey : messagesSection.getKeys(false)) {
                try {
                    String normalizedKey = causeKey.toLowerCase().replace('-', '_');
                    ConfigurationSection causeSection = messagesSection.getConfigurationSection(causeKey);
                    if (causeSection == null) {
                        this.debugger.warn("DeathMessageLoader", "Invalid configuration structure for death cause '" + causeKey + "' in deaths.yml");
                        ++totalSkipped;
                        continue;
                    }
                    boolean enabled = causeSection.getBoolean("enabled", true);
                    List variants = null;
                    try {
                        variants = causeSection.getStringList("variants");
                    }
                    catch (Exception e) {
                        this.debugger.warn("DeathMessageLoader", "Failed to read variants for death cause '" + causeKey + "': " + e.getMessage());
                        ++totalSkipped;
                        continue;
                    }
                    if (variants == null || variants.isEmpty()) {
                        if (this.deathConfig.isDebugEnabled()) {
                            this.debugger.warn("DeathMessageLoader", "No message variants found for death cause: " + causeKey + " in " + this.deathsFile.getAbsolutePath());
                        }
                        ++totalSkipped;
                        continue;
                    }
                    Map<DamageType, List<String>> indirectVariantsByType = this.loadIndirectVariants(causeSection, causeKey);
                    ArrayList<DeathMessage> deathMessages = new ArrayList<DeathMessage>();
                    int variantIndex = 0;
                    for (String variant : variants) {
                        ++variantIndex;
                        if (this.validateMessage(variant)) {
                            String translatedVariant = ColorUtil.parseColor(variant);
                            if (!indirectVariantsByType.isEmpty()) {
                                Map<DamageType, String> indirectVariants = this.selectIndirectVariants(indirectVariantsByType);
                                String genericIndirect = indirectVariants.get((Object)DamageType.UNKNOWN);
                                indirectVariants.remove((Object)DamageType.UNKNOWN);
                                HashMap<DamageType, String> translatedIndirectVariants = new HashMap<DamageType, String>();
                                for (Map.Entry<DamageType, String> entry : indirectVariants.entrySet()) {
                                    translatedIndirectVariants.put(entry.getKey(), ColorUtil.parseColor(entry.getValue()));
                                }
                                String translatedGenericIndirect = genericIndirect != null ? ColorUtil.parseColor(genericIndirect) : null;
                                deathMessages.add(new DeathMessage(normalizedKey, translatedVariant, enabled, translatedIndirectVariants, translatedGenericIndirect));
                            } else {
                                deathMessages.add(new DeathMessage(normalizedKey, translatedVariant, enabled));
                            }
                            ++totalLoaded;
                            continue;
                        }
                        if (this.deathConfig.isDebugEnabled()) {
                            this.debugger.warn("DeathMessageLoader", "Empty or null message variant #" + variantIndex + " found for cause '" + causeKey + "' in " + this.deathsFile.getAbsolutePath() + " - skipping");
                        }
                        ++emptyVariants;
                        ++totalSkipped;
                    }
                    if (!deathMessages.isEmpty()) {
                        messages.put(normalizedKey, deathMessages);
                        continue;
                    }
                    this.debugger.warn("DeathMessageLoader", "Death cause '" + causeKey + "' has no valid message variants after validation");
                }
                catch (Exception e) {
                    this.debugger.error("DeathMessageLoader", "Error processing death cause '" + causeKey + "' in deaths.yml: " + e.getMessage(), e);
                    ++totalSkipped;
                }
            }
            this.debugger.info("DeathMessageLoader", "Loaded " + totalLoaded + " death message variants across " + messages.size() + " causes from " + this.deathsFile.getName());
            if (totalSkipped > 0) {
                this.debugger.info("DeathMessageLoader", "Skipped " + totalSkipped + " invalid entries (" + unknownCauses + " unknown causes, " + emptyVariants + " empty variants)");
            }
        }
        catch (Exception e) {
            this.debugger.error("DeathMessageLoader", "Critical error loading death messages from " + this.deathsFile.getAbsolutePath() + ": " + e.getMessage(), e);
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultFile() {
        OutputStreamWriter writer = null;
        try {
            boolean created;
            File parentDir = this.deathsFile.getParentFile();
            if (parentDir != null && !parentDir.exists() && !(created = parentDir.mkdirs())) {
                this.debugger.error("DeathMessageLoader", "Failed to create parent directory for deaths.yml at " + parentDir.getAbsolutePath(), null);
                return;
            }
            if (this.deathsFile.createNewFile()) {
                this.debugger.info("DeathMessageLoader", "Creating default deaths.yml file at " + this.deathsFile.getAbsolutePath());
                writer = new FileWriter(this.deathsFile);
                writer.write(this.getDefaultFileContent());
                writer.flush();
                this.debugger.info("DeathMessageLoader", "Default deaths.yml created successfully with example messages for all death causes");
            } else {
                this.debugger.info("DeathMessageLoader", "deaths.yml already exists at " + this.deathsFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            this.debugger.error("DeathMessageLoader", "Failed to create default deaths.yml at " + this.deathsFile.getAbsolutePath() + ": " + e.getMessage(), e);
            this.debugger.error("DeathMessageLoader", "Please check file permissions and disk space", null);
        }
        catch (Exception e) {
            this.debugger.error("DeathMessageLoader", "Unexpected error creating default deaths.yml: " + e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.debugger.warn("DeathMessageLoader", "Failed to close file writer for deaths.yml: " + e.getMessage());
                }
            }
        }
    }

    private String getDefaultFileContent() {
        try {
            String line;
            InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream("deaths.yml");
            if (resourceStream == null) {
                this.debugger.error("DeathMessageLoader", "Could not find deaths.yml in plugin resources", null);
                return "";
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
            reader.close();
            return content.toString();
        }
        catch (IOException e) {
            this.debugger.error("DeathMessageLoader", "Failed to read deaths.yml from plugin resources: " + e.getMessage(), e);
            return "";
        }
    }

    private Map<DamageType, List<String>> loadIndirectVariants(ConfigurationSection causeSection, String causeKey) {
        HashMap<DamageType, List<String>> indirectVariants = new HashMap<DamageType, List<String>>();
        try {
            List genericVariants;
            ConfigurationSection indirectSection = causeSection.getConfigurationSection("indirect-variants");
            if (indirectSection == null) {
                return indirectVariants;
            }
            if (indirectSection.contains("generic") && (genericVariants = indirectSection.getStringList("generic")) != null && !genericVariants.isEmpty()) {
                ArrayList<String> validGeneric = new ArrayList<String>();
                for (String variant : genericVariants) {
                    if (!this.validateMessage(variant)) continue;
                    validGeneric.add(variant);
                }
                if (!validGeneric.isEmpty()) {
                    indirectVariants.put(DamageType.UNKNOWN, validGeneric);
                }
            }
            for (DamageType damageType : DamageType.values()) {
                List typeVariants;
                String configKey;
                if (damageType == DamageType.UNKNOWN || !indirectSection.contains(configKey = damageType.getConfigKey()) || (typeVariants = indirectSection.getStringList(configKey)) == null || typeVariants.isEmpty()) continue;
                ArrayList<String> validVariants = new ArrayList<String>();
                for (String variant : typeVariants) {
                    if (!this.validateMessage(variant)) continue;
                    validVariants.add(variant);
                }
                if (validVariants.isEmpty()) continue;
                indirectVariants.put(damageType, validVariants);
            }
            if (this.deathConfig.isDebugEnabled() && !indirectVariants.isEmpty()) {
                this.debugger.debug("DeathMessageLoader", "Loaded " + indirectVariants.size() + " indirect variant types for cause: " + causeKey);
            }
            if (indirectVariants.isEmpty() && indirectSection != null && this.deathConfig.isDebugEnabled()) {
                this.debugger.warn("DeathMessageLoader", "indirect-variants section exists for '" + causeKey + "' but no valid variants were loaded");
            }
        }
        catch (Exception e) {
            this.debugger.error("DeathMessageLoader", "Error loading indirect variants for cause '" + causeKey + "': " + e.getMessage(), e);
        }
        return indirectVariants;
    }

    private Map<DamageType, String> selectIndirectVariants(Map<DamageType, List<String>> indirectVariantsByType) {
        HashMap<DamageType, String> selected = new HashMap<DamageType, String>();
        try {
            for (Map.Entry<DamageType, List<String>> entry : indirectVariantsByType.entrySet()) {
                List<String> variants = entry.getValue();
                if (variants == null || variants.isEmpty()) continue;
                int randomIndex = ThreadLocalRandom.current().nextInt(variants.size());
                selected.put(entry.getKey(), variants.get(randomIndex));
            }
        }
        catch (Exception e) {
            this.debugger.error("DeathMessageLoader", "Error selecting indirect variants: " + e.getMessage(), e);
        }
        return selected;
    }

    private boolean validateMessage(String message) {
        try {
            if (message == null) {
                if (this.deathConfig.isDebugEnabled()) {
                    this.debugger.warn("DeathMessageLoader", "Null message variant detected during validation");
                }
                return false;
            }
            String trimmed = message.trim();
            if (trimmed.isEmpty()) {
                if (this.deathConfig.isDebugEnabled()) {
                    this.debugger.warn("DeathMessageLoader", "Empty or whitespace-only message variant detected during validation");
                }
                return false;
            }
            if (trimmed.length() < 3) {
                if (this.deathConfig.isDebugEnabled()) {
                    this.debugger.warn("DeathMessageLoader", "Message variant too short (less than 3 characters): '" + trimmed + "'");
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.debugger.warn("DeathMessageLoader", "Error validating message variant: " + e.getMessage());
            return false;
        }
    }
}

