/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.config;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.util.chat.formatting.MessageFormatter;
import com.nonxedy.nonchat.util.lang.LanguageManager;
import net.kyori.adventure.text.Component;

public class PluginMessages {
    private final MessageFormatter formatter;
    private final LanguageManager languageManager;
    private final Nonchat plugin;

    public PluginMessages(Nonchat plugin) {
        this.plugin = plugin;
        this.languageManager = new LanguageManager(plugin.getDataFolder());
        this.formatter = new MessageFormatter(this);
    }

    public void loadLanguage() {
        String lang = this.plugin.getConfig().getString("language", "en");
        this.languageManager.setLanguage(lang);
    }

    public void reloadConfig() {
        this.languageManager.reload();
        this.loadLanguage();
    }

    public String getString(String path) {
        return this.languageManager.getMessage(path);
    }

    public Component getFormatted(String path, Object ... args) {
        return this.formatter.format(path, args);
    }
}

