/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.core;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.util.chat.filters.LinkDetector;
import com.nonxedy.nonchat.util.core.broadcast.BroadcastMessage;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class BroadcastManager {
    private final Nonchat plugin;
    private final PluginConfig config;
    private final List<BukkitTask> activeTasks;
    private List<BroadcastMessage> messageSequence;

    public BroadcastManager(Nonchat plugin, PluginConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.activeTasks = new ArrayList<BukkitTask>();
        this.messageSequence = new ArrayList<BroadcastMessage>();
        this.start();
    }

    public void start() {
        this.stop();
        Map<String, BroadcastMessage> configuredMessages = this.config.getBroadcastMessages();
        List enabledMessages = configuredMessages.values().stream().filter(BroadcastMessage::isEnabled).collect(Collectors.toList());
        if (enabledMessages.isEmpty()) {
            return;
        }
        this.messageSequence = new ArrayList(enabledMessages);
        if (this.config.isRandomBroadcastEnabled()) {
            Collections.shuffle(this.messageSequence);
        }
        long delay = 0L;
        long totalPeriod = this.messageSequence.stream().mapToLong(BroadcastMessage::getInterval).sum() * 20L;
        for (BroadcastMessage message : this.messageSequence) {
            BukkitTask task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.broadcast((CommandSender)Bukkit.getConsoleSender(), message.getMessage()), delay, totalPeriod);
            this.activeTasks.add(task);
            delay += (long)message.getInterval() * 20L;
        }
    }

    public void broadcast(CommandSender sender, String message) {
        try {
            Component formatted = ColorUtil.containsMiniMessageTags(message) ? ColorUtil.parseMiniMessageComponent(message) : LinkDetector.makeLinksClickable(message);
            Bukkit.broadcast((Component)formatted);
        }
        catch (NoSuchMethodError e) {
            this.plugin.logError("Adventure API isn't avaible: " + e.getMessage());
            String legacyMessage = ColorUtil.parseColor(message);
            Bukkit.broadcastMessage((String)legacyMessage);
        }
    }

    public void stop() {
        this.activeTasks.forEach(BukkitTask::cancel);
        this.activeTasks.clear();
        this.messageSequence.clear();
    }

    public void reload() {
        this.stop();
        this.start();
    }
}

