/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.core;

import com.nonxedy.nonchat.config.DeathConfig;
import com.nonxedy.nonchat.config.DeathMessageLoader;
import com.nonxedy.nonchat.util.core.debugging.Debugger;
import com.nonxedy.nonchat.util.death.DamageType;
import com.nonxedy.nonchat.util.death.DeathMessage;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

public class DeathMessageManager {
    private final Map<String, List<DeathMessage>> messageCache = new HashMap<String, List<DeathMessage>>();
    private final DeathMessageLoader loader;
    private final DeathConfig deathConfig;
    private final Debugger debugger;

    public DeathMessageManager(File dataFolder, Debugger debugger, DeathConfig deathConfig) {
        this.loader = new DeathMessageLoader(dataFolder, debugger, deathConfig);
        this.deathConfig = deathConfig;
        this.debugger = debugger;
    }

    public void loadMessages() {
        try {
            this.clearCache();
            Map<String, List<DeathMessage>> loadedMessages = null;
            try {
                loadedMessages = this.loader.loadAllMessages();
            }
            catch (Exception e) {
                this.debugger.error("DeathMessageManager", "Failed to load death messages from configuration: " + e.getMessage(), e);
                loadedMessages = new HashMap<String, List<DeathMessage>>();
            }
            if (loadedMessages == null) {
                this.debugger.warn("DeathMessageManager", "Death message loader returned null, using empty message cache");
                loadedMessages = new HashMap<String, List<DeathMessage>>();
            }
            this.messageCache.putAll(loadedMessages);
            if (this.deathConfig.isDebugEnabled()) {
                this.logStatistics();
            }
            if (this.messageCache.isEmpty()) {
                this.debugger.warn("DeathMessageManager", "No death messages loaded. Death message system will use fallback behavior.");
                this.debugger.warn("DeathMessageManager", "Check deaths.yml for configuration errors or create a new file by deleting the existing one.");
            }
        }
        catch (Exception e) {
            this.debugger.error("DeathMessageManager", "Critical error in loadMessages(): " + e.getMessage(), e);
        }
    }

    public DeathMessage selectMessage(String causeKey, boolean isIndirect, DamageType damageType) {
        try {
            if (causeKey == null || causeKey.isEmpty()) {
                if (this.deathConfig.isDebugEnabled()) {
                    this.debugger.warn("DeathMessageManager", "Attempted to select message for null or empty death cause key");
                }
                return null;
            }
            String normalizedKey = causeKey.toLowerCase().replace('-', '_');
            if (isIndirect) {
                DeathMessage indirectMessage = this.selectIndirectMessage(normalizedKey, damageType);
                if (indirectMessage != null) {
                    return indirectMessage;
                }
                if (this.deathConfig.isDebugEnabled()) {
                    this.debugger.debug("DeathMessageManager", "No indirect message found for cause " + normalizedKey + ", falling back to standard message");
                }
            }
            return this.selectStandardMessage(normalizedKey);
        }
        catch (Exception e) {
            this.debugger.error("DeathMessageManager", "Unexpected error in selectMessage() for cause " + (causeKey != null ? causeKey : "null") + ": " + e.getMessage(), e);
            return null;
        }
    }

    private DeathMessage selectIndirectMessage(String causeKey, DamageType damageType) {
        try {
            if (causeKey == null || causeKey.isEmpty()) {
                return null;
            }
            List<DeathMessage> messages = this.messageCache.get(causeKey);
            if (messages == null || messages.isEmpty()) {
                return null;
            }
            List<DeathMessage> indirectMessages = messages.stream().filter(message -> message != null && message.isEnabled() && message.hasIndirectVariants()).filter(message -> {
                if (damageType != null && message.hasVariantForDamageType(damageType)) {
                    return true;
                }
                return message.getGenericIndirectMessage() != null;
            }).collect(Collectors.toList());
            if (indirectMessages.isEmpty()) {
                if (this.deathConfig.isDebugEnabled()) {
                    this.debugger.debug("DeathMessageManager", "No indirect message variants found for cause: " + causeKey);
                }
                return null;
            }
            return this.selectRandomVariant(indirectMessages);
        }
        catch (Exception e) {
            this.debugger.error("DeathMessageManager", "Unexpected error in selectIndirectMessage() for cause " + (causeKey != null ? causeKey : "null") + ": " + e.getMessage(), e);
            return null;
        }
    }

    private DeathMessage selectStandardMessage(String causeKey) {
        try {
            if (causeKey == null || causeKey.isEmpty()) {
                if (this.deathConfig.isDebugEnabled()) {
                    this.debugger.warn("DeathMessageManager", "Attempted to select message for null or empty death cause key");
                }
                return null;
            }
            List<DeathMessage> messages = this.messageCache.get(causeKey);
            if (messages == null || messages.isEmpty()) {
                if (this.deathConfig.isDebugEnabled()) {
                    this.debugger.debug("DeathMessageManager", "No custom messages configured for death cause: " + causeKey);
                }
                return null;
            }
            List<DeathMessage> enabledMessages = messages.stream().filter(message -> message != null && message.isEnabled()).collect(Collectors.toList());
            if (enabledMessages.isEmpty()) {
                if (this.deathConfig.isDebugEnabled()) {
                    this.debugger.debug("DeathMessageManager", "No enabled messages for death cause: " + causeKey);
                }
                return null;
            }
            return this.selectRandomVariant(enabledMessages);
        }
        catch (Exception e) {
            this.debugger.error("DeathMessageManager", "Unexpected error in selectStandardMessage() for cause " + (causeKey != null ? causeKey : "null") + ": " + e.getMessage(), e);
            return null;
        }
    }

    private DeathMessage selectRandomVariant(List<DeathMessage> messages) {
        if (messages == null || messages.isEmpty()) {
            return null;
        }
        try {
            int randomIndex = ThreadLocalRandom.current().nextInt(messages.size());
            return messages.get(randomIndex);
        }
        catch (Exception e) {
            this.debugger.warn("DeathMessageManager", "Error selecting random variant, using first: " + e.getMessage());
            return messages.get(0);
        }
    }

    public boolean hasCustomMessages(String causeKey) {
        if (causeKey == null || causeKey.isEmpty()) {
            return false;
        }
        String normalizedKey = causeKey.toLowerCase().replace('-', '_');
        List<DeathMessage> messages = this.messageCache.get(normalizedKey);
        if (messages == null || messages.isEmpty()) {
            return false;
        }
        for (DeathMessage message : messages) {
            if (!message.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public int getMessageCount(String causeKey) {
        if (causeKey == null || causeKey.isEmpty()) {
            return 0;
        }
        String normalizedKey = causeKey.toLowerCase().replace('-', '_');
        List<DeathMessage> messages = this.messageCache.get(normalizedKey);
        if (messages == null || messages.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (DeathMessage message : messages) {
            if (!message.isEnabled()) continue;
            ++count;
        }
        return count;
    }

    public void clearCache() {
        this.messageCache.clear();
        if (this.deathConfig.isDebugEnabled()) {
            this.debugger.info("DeathMessageManager", "Death message cache cleared");
        }
    }

    public Map<String, Integer> getStatistics() {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        for (Map.Entry<String, List<DeathMessage>> entry : this.messageCache.entrySet()) {
            String causeKey = entry.getKey();
            int enabledCount = this.getMessageCount(causeKey);
            if (enabledCount <= 0) continue;
            stats.put(causeKey, enabledCount);
        }
        return stats;
    }

    private void logStatistics() {
        Map<String, Integer> stats = this.getStatistics();
        if (stats.isEmpty()) {
            this.debugger.info("DeathMessageManager", "No death messages loaded");
            return;
        }
        this.debugger.info("DeathMessageManager", "Death message statistics:");
        int totalMessages = 0;
        for (Map.Entry<String, Integer> entry : stats.entrySet()) {
            int count = entry.getValue();
            this.debugger.info("DeathMessageManager", "  " + entry.getKey() + ": " + count + " variant(s)");
            totalMessages += count;
        }
        this.debugger.info("DeathMessageManager", "Total: " + totalMessages + " message variants across " + stats.size() + " causes");
    }
}

