/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.core;

import com.nonxedy.nonchat.libs.caffeine.cache.Cache;
import com.nonxedy.nonchat.libs.caffeine.cache.Caffeine;
import com.nonxedy.nonchat.util.death.DamageRecord;
import com.nonxedy.nonchat.util.death.DamageType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class IndirectDeathTracker {
    private final Cache<UUID, DamageRecord> damageCache;

    public IndirectDeathTracker() {
        this.damageCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).maximumSize(1000L).recordStats().build();
    }

    public IndirectDeathTracker(int expirationSeconds) {
        this.damageCache = Caffeine.newBuilder().expireAfterWrite(expirationSeconds, TimeUnit.SECONDS).maximumSize(1000L).recordStats().build();
    }

    public void recordDamage(Player victim, Player damager, DamageType type) {
        if (victim == null || damager == null || type == null) {
            return;
        }
        DamageRecord record = new DamageRecord(damager.getUniqueId(), damager.getName(), type, System.currentTimeMillis());
        this.damageCache.put(victim.getUniqueId(), record);
    }

    @Nullable
    public DamageRecord getLastDamager(Player victim) {
        if (victim == null) {
            return null;
        }
        return this.damageCache.getIfPresent(victim.getUniqueId());
    }

    public void clearPlayer(Player player) {
        if (player == null) {
            return;
        }
        this.damageCache.invalidate(player.getUniqueId());
    }

    public void clearAll() {
        this.damageCache.invalidateAll();
        this.damageCache.cleanUp();
    }

    public Map<String, Object> getStatistics() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("size", this.damageCache.estimatedSize());
        stats.put("hitRate", this.damageCache.stats().hitRate());
        stats.put("missRate", this.damageCache.stats().missRate());
        stats.put("evictionCount", this.damageCache.stats().evictionCount());
        stats.put("hitCount", this.damageCache.stats().hitCount());
        stats.put("missCount", this.damageCache.stats().missCount());
        return stats;
    }
}

