/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.listener;

import com.nonxedy.nonchat.config.DeathConfig;
import com.nonxedy.nonchat.core.IndirectDeathTracker;
import com.nonxedy.nonchat.util.core.debugging.Debugger;
import com.nonxedy.nonchat.util.death.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.projectiles.ProjectileSource;

public class DamageTrackingListener
implements Listener {
    private final IndirectDeathTracker tracker;
    private final Debugger debugger;
    private final DeathConfig deathConfig;
    private final double minimumDamage;

    public DamageTrackingListener(IndirectDeathTracker tracker, Debugger debugger, DeathConfig deathConfig, double minimumDamage) {
        this.tracker = tracker;
        this.debugger = debugger;
        this.deathConfig = deathConfig;
        this.minimumDamage = minimumDamage;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (!this.deathConfig.isIndirectTrackingEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player victim = (Player)event.getEntity();
        double damageInHearts = event.getFinalDamage() / 2.0;
        if (damageInHearts < this.minimumDamage) {
            if (this.deathConfig.isDebugEnabled()) {
                this.debugger.debug("DamageTrackingListener", String.format("Damage below threshold: %s -> %s (%.1f hearts < %.1f hearts minimum)", event.getDamager().getType().name(), victim.getName(), damageInHearts, this.minimumDamage));
            }
            return;
        }
        Player damager = this.extractDamager(event.getDamager());
        if (damager == null) {
            if (this.deathConfig.isDebugEnabled()) {
                this.debugger.debug("DamageTrackingListener", String.format("No player damager found for damage to %s (damager type: %s)", victim.getName(), event.getDamager().getType().name()));
            }
            return;
        }
        if (victim.getUniqueId().equals(damager.getUniqueId())) {
            if (this.deathConfig.isDebugEnabled()) {
                this.debugger.debug("DamageTrackingListener", String.format("Ignoring self-damage: %s", victim.getName()));
            }
            return;
        }
        DamageType damageType = this.classifyDamageType(event);
        this.tracker.recordDamage(victim, damager, damageType);
        if (this.deathConfig.isDebugEnabled()) {
            this.debugger.info("DamageTrackingListener", String.format("Recorded %s damage: %s -> %s (%.1f hearts, cause: %s)", damageType.name(), damager.getName(), victim.getName(), damageInHearts, event.getCause().name()));
        }
    }

    private Player extractDamager(Entity damager) {
        TNTPrimed tnt;
        Entity source;
        if (damager == null) {
            return null;
        }
        if (damager instanceof Player) {
            return (Player)damager;
        }
        if (damager instanceof Projectile) {
            Projectile projectile = (Projectile)damager;
            ProjectileSource shooter = projectile.getShooter();
            if (shooter == null) {
                if (this.deathConfig.isDebugEnabled()) {
                    this.debugger.debug("DamageTrackingListener", "Projectile has null shooter");
                }
                return null;
            }
            if (shooter instanceof Player) {
                return (Player)shooter;
            }
        }
        if (damager instanceof TNTPrimed && (source = (tnt = (TNTPrimed)damager).getSource()) instanceof Player) {
            return (Player)source;
        }
        return null;
    }

    private DamageType classifyDamageType(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        if (damager == null) {
            return DamageType.UNKNOWN;
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (damager instanceof Projectile) {
            return DamageType.PROJECTILE;
        }
        if (cause == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || cause == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || damager instanceof TNTPrimed) {
            return DamageType.EXPLOSION;
        }
        if (damager instanceof Player && (cause == EntityDamageEvent.DamageCause.ENTITY_ATTACK || cause == EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK)) {
            return DamageType.MELEE;
        }
        if (damager instanceof Player) {
            double damage = event.getFinalDamage();
            if (damage < 4.0) {
                return DamageType.KNOCKBACK;
            }
            return DamageType.MELEE;
        }
        return DamageType.UNKNOWN;
    }
}

