/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.listener;

import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.service.DeathMessageService;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;

public class DeathListener
implements Listener {
    private final PluginConfig config;
    private final DeathMessageService deathMessageService;
    private static boolean deprecationWarningShown = false;

    public DeathListener(PluginConfig config) {
        this.config = config;
        this.deathMessageService = null;
    }

    public DeathListener(PluginConfig config, DeathMessageService deathMessageService) {
        this.config = config;
        this.deathMessageService = deathMessageService;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (this.deathMessageService != null) {
            try {
                this.deathMessageService.handleDeath(event);
                if (event.deathMessage() != null && !event.deathMessage().equals((Object)Component.empty())) {
                    return;
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "Error handling death with deaths.yml system: {0}", e.getMessage());
            }
        }
        if (!this.config.isDeathMessagesEnabled()) {
            return;
        }
        String deathFormat = this.config.getDeathFormat();
        if (deathFormat == null || deathFormat.isEmpty()) {
            return;
        }
        this.logDeprecationWarning();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                deathFormat = PlaceholderAPI.setPlaceholders((Player)player, (String)deathFormat);
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "Error processing death message placeholders: {0}", e.getMessage());
            }
        }
        event.deathMessage(ColorUtil.parseComponent(deathFormat));
    }

    private void logDeprecationWarning() {
        if (!deprecationWarningShown) {
            Bukkit.getLogger().log(Level.WARNING, "[nonchat] DEPRECATION WARNING: The death message configuration in config.yml is deprecated.");
            Bukkit.getLogger().log(Level.WARNING, "[nonchat] Please migrate to the new deaths.yml file for more features and better customization.");
            Bukkit.getLogger().log(Level.WARNING, "[nonchat] The old system will be removed in a future version.");
            deprecationWarningShown = true;
        }
    }
}

