/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.listener;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.api.Channel;
import com.nonxedy.nonchat.core.ChatManager;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.GameChatMessagePreProcessEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class DiscordSRVListener
implements Listener {
    private final Nonchat plugin;

    public DiscordSRVListener(Nonchat plugin) {
        this.plugin = plugin;
        Plugin discordSRV = plugin.getServer().getPluginManager().getPlugin("DiscordSRV");
        if (discordSRV != null && discordSRV.isEnabled()) {
            DiscordSRV.api.subscribe((Object)this);
            plugin.logResponse("Successfully registered DiscordSRV chat listener!");
        }
    }

    @Subscribe
    public void onGameChatMessagePreProcess(GameChatMessagePreProcessEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (player == null) {
            return;
        }
        ChatManager chatManager = this.plugin.getChatManager();
        if (chatManager == null) {
            return;
        }
        Channel channel = chatManager.getChannelManager().getChannelForMessage(message);
        if (channel != null && channel.hasPrefix() && message.startsWith(channel.getPrefix())) {
            message = message.substring(channel.getPrefix().length());
        }
        if (channel == null) {
            channel = chatManager.getPlayerChannel(player);
        }
        event.setCancelled(true);
    }

    public void shutdown() {
        Plugin discordSRV = this.plugin.getServer().getPluginManager().getPlugin("DiscordSRV");
        if (discordSRV != null && discordSRV.isEnabled()) {
            DiscordSRV.api.unsubscribe((Object)this);
        }
    }
}

