/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.listener;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.api.Channel;
import com.nonxedy.nonchat.core.ChatManager;
import com.nonxedy.nonchat.listener.ChatListener;
import com.nonxedy.nonchat.service.ChatService;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class PaperChatListener
extends ChatListener {
    private final Nonchat plugin;
    private final Map<String, String> playerMessages = new ConcurrentHashMap<String, String>();
    private final Map<String, String> modifiedPrefixes = new ConcurrentHashMap<String, String>();

    public PaperChatListener(Nonchat plugin, ChatManager chatManager, ChatService chatService) {
        super(chatManager, chatService);
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onAsyncPlayerChatLowest(AsyncPlayerChatEvent event) {
        Channel channel;
        String message = event.getMessage();
        if (message.length() > 0 && this.chatManager != null && (channel = this.chatManager.getChannelManager().getChannelForMessage(message)) != null && channel.hasPrefix() && message.startsWith(channel.getPrefix())) {
            event.setMessage(message.substring(channel.getPrefix().length()));
            this.modifiedPrefixes.put(event.getPlayer().getUniqueId().toString(), channel.getPrefix());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onAsyncPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String playerId = player.getUniqueId().toString();
        Object message = event.getMessage();
        String prefix = this.modifiedPrefixes.remove(playerId);
        if (prefix != null) {
            message = prefix + (String)message;
        }
        this.playerMessages.put(playerId, (String)message);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onAsyncChat(AsyncChatEvent event) {
        event.setCancelled(true);
        Player player = event.getPlayer();
        String playerId = player.getUniqueId().toString();
        String message = this.playerMessages.remove(playerId);
        String finalMessage = message != null ? message : PlainTextComponentSerializer.plainText().serialize(event.message());
        CompletableFuture.runAsync(() -> {
            try {
                if (this.chatService != null) {
                    this.chatService.handleChat(player, finalMessage);
                } else if (this.chatManager != null) {
                    this.chatManager.processChat(player, finalMessage);
                }
            }
            catch (Exception e) {
                this.plugin.logError("Async chat processing failed: " + e.getMessage());
            }
        });
    }
}

