/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.placeholders;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.api.Channel;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class NonchatExpansion
extends PlaceholderExpansion {
    private final Nonchat plugin;

    public NonchatExpansion(Nonchat plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getAuthor() {
        return "nonxedy";
    }

    @NotNull
    public String getIdentifier() {
        return "nonchat";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (player == null) {
            return "";
        }
        return switch (identifier) {
            case "spy_enabled" -> {
                if (this.plugin.getSpyCommand().isSpying(player)) {
                    yield ColorUtil.parseColor(this.plugin.getConfigService().getMessages().getString("placeholders.spy.enabled"));
                }
                yield ColorUtil.parseColor(this.plugin.getConfigService().getMessages().getString("placeholders.spy.disabled"));
            }
            case "bubble_enabled" -> {
                if (this.plugin.getConfigService().getConfig().isChatBubblesEnabled()) {
                    yield ColorUtil.parseColor(this.plugin.getConfigService().getMessages().getString("placeholders.bubble.enabled"));
                }
                yield ColorUtil.parseColor(this.plugin.getConfigService().getMessages().getString("placeholders.bubble.disabled"));
            }
            case "caps_filter_enabled" -> {
                if (this.plugin.getConfigService().getConfig().isCapsFilterEnabled()) {
                    yield ColorUtil.parseColor(this.plugin.getConfigService().getMessages().getString("placeholders.caps-filter.enabled"));
                }
                yield ColorUtil.parseColor(this.plugin.getConfigService().getMessages().getString("placeholders.caps-filter.disabled"));
            }
            case "current_channel" -> {
                Channel currentChannel = this.plugin.getChatManager().getPlayerChannel(player);
                if (currentChannel != null) {
                    yield ColorUtil.parseColor(this.plugin.getConfigService().getMessages().getString("placeholders.current-channel.format").replace("{channel}", currentChannel.getDisplayName()).replace("{id}", currentChannel.getId()));
                }
                yield ColorUtil.parseColor(this.plugin.getConfigService().getMessages().getString("placeholders.current-channel.none"));
            }
            default -> null;
        };
    }
}

