/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.placeholders.impl;

import com.nonxedy.nonchat.api.InteractivePlaceholder;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ConfigurablePlaceholder
implements InteractivePlaceholder {
    private final String placeholder;
    private final String activationKey;
    private final String displayName;
    private final String description;
    private boolean enabled;
    private String permission;
    private String format;
    private List<String> hoverText;
    private ClickAction clickAction;

    public ConfigurablePlaceholder(String placeholder, String activationKey, String displayName, String description, boolean enabled, String permission, String format, List<String> hoverText, String clickActionType, String clickActionValue) {
        this.placeholder = placeholder;
        this.activationKey = activationKey != null && !activationKey.isEmpty() ? activationKey : placeholder;
        this.displayName = displayName;
        this.description = description;
        this.enabled = enabled;
        this.permission = permission != null ? permission : "";
        this.format = format != null && !format.isEmpty() ? format : "[" + placeholder + "]";
        this.hoverText = hoverText;
        if (clickActionType != null && clickActionValue != null && !clickActionType.equals("none")) {
            this.clickAction = new ClickAction(clickActionType, clickActionValue);
        }
    }

    @Override
    @NotNull
    public String getPlaceholder() {
        return this.activationKey;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Component process(Player player, String ... arguments) {
        ClickEvent clickEvent;
        if (this.placeholder.equals("item")) {
            return this.processItemPlaceholder(player);
        }
        if (this.placeholder.equals("ping")) {
            return this.processPingPlaceholder(player);
        }
        Component component = ColorUtil.parseComponent(this.format);
        if (this.hoverText != null && !this.hoverText.isEmpty()) {
            Component hoverComponent = this.createHoverComponent(player);
            component = component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComponent));
        }
        if (this.clickAction != null && (clickEvent = this.createClickEvent(player)) != null) {
            component = component.clickEvent(clickEvent);
        }
        return component;
    }

    private Component processItemPlaceholder(Player player) {
        ClickEvent clickEvent;
        String processedFormat = this.processPlaceholdersAsString(player, this.format);
        Component itemComponent = ColorUtil.parseComponent(processedFormat);
        if (this.hoverText != null && !this.hoverText.isEmpty()) {
            Component hoverComponent = this.createHoverComponent(player);
            itemComponent = itemComponent.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComponent));
        }
        if (this.clickAction != null && (clickEvent = this.createClickEvent(player)) != null) {
            itemComponent = itemComponent.clickEvent(clickEvent);
        }
        return itemComponent;
    }

    private String getItemDisplayName(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return "Air";
        }
        return item.getItemMeta() != null && item.getItemMeta().hasDisplayName() ? item.getItemMeta().getDisplayName() : item.getType().name().replace("_", " ").toLowerCase();
    }

    private Component createItemCard(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return Component.text((String)"[Air]").color((TextColor)NamedTextColor.GRAY);
        }
        String itemName = item.getItemMeta() != null && item.getItemMeta().hasDisplayName() ? item.getItemMeta().getDisplayName() : item.getType().name().replace("_", " ").toLowerCase();
        Component itemComponent = ((TextComponent)Component.text((String)("[" + itemName + "]")).color((TextColor)NamedTextColor.AQUA)).decorate(TextDecoration.BOLD);
        TextComponent.Builder hoverBuilder = Component.text();
        ((TextComponent.Builder)((TextComponent.Builder)hoverBuilder.append((Component)Component.text((String)"Item: ", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)itemName, (TextColor)NamedTextColor.WHITE))).append((Component)Component.newline());
        if (item.getAmount() > 1) {
            ((TextComponent.Builder)((TextComponent.Builder)hoverBuilder.append((Component)Component.text((String)"Amount: ", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)(item.getAmount() + "x"), (TextColor)NamedTextColor.WHITE))).append((Component)Component.newline());
        }
        if (item.getItemMeta() != null && item.getItemMeta().hasLore()) {
            ((TextComponent.Builder)hoverBuilder.append((Component)Component.text((String)"Description:", (TextColor)NamedTextColor.GOLD))).append((Component)Component.newline());
            for (String loreLine : item.getItemMeta().getLore()) {
                ((TextComponent.Builder)hoverBuilder.append((Component)Component.text((String)("  " + loreLine), (TextColor)NamedTextColor.GRAY))).append((Component)Component.newline());
            }
        }
        if (item.getItemMeta() != null && item.getItemMeta().hasEnchants()) {
            ((TextComponent.Builder)hoverBuilder.append((Component)Component.text((String)"Enchantments:", (TextColor)NamedTextColor.GOLD))).append((Component)Component.newline());
            for (Enchantment enchantment : item.getItemMeta().getEnchants().keySet()) {
                int level = item.getItemMeta().getEnchantLevel(enchantment);
                String enchantName = enchantment.getKey().getKey().replace("_", " ").toLowerCase();
                ((TextComponent.Builder)hoverBuilder.append((Component)Component.text((String)("  " + enchantName + " " + level), (TextColor)NamedTextColor.BLUE))).append((Component)Component.newline());
            }
        }
        if (item.getType().getMaxDurability() > 0) {
            short maxDurability = item.getType().getMaxDurability();
            int currentDurability = maxDurability - (item.getDurability() & 0xFFFF);
            double percentage = (double)currentDurability / (double)maxDurability * 100.0;
            NamedTextColor durabilityColor = percentage > 75.0 ? NamedTextColor.GREEN : (percentage > 50.0 ? NamedTextColor.YELLOW : (percentage > 25.0 ? NamedTextColor.GOLD : NamedTextColor.RED));
            ((TextComponent.Builder)hoverBuilder.append((Component)Component.text((String)"Durability: ", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)(currentDurability + "/" + maxDurability + " (" + String.format("%.1f", percentage) + "%)"), (TextColor)durabilityColor));
        }
        return itemComponent.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverBuilder.build()));
    }

    private Component processPingPlaceholder(Player player) {
        ClickEvent clickEvent;
        String processedFormat = this.processPlaceholdersAsString(player, this.format);
        Component pingComponent = ColorUtil.parseComponent(processedFormat);
        if (this.hoverText != null && !this.hoverText.isEmpty()) {
            Component hoverComponent = this.createHoverComponent(player);
            pingComponent = pingComponent.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComponent));
        }
        if (this.clickAction != null && (clickEvent = this.createClickEvent(player)) != null) {
            pingComponent = pingComponent.clickEvent(clickEvent);
        }
        return pingComponent;
    }

    private Component createHoverComponent(Player player) {
        TextComponent.Builder builder = Component.text();
        for (String line : this.hoverText) {
            Component processedLine;
            if (builder.children().isEmpty()) {
                processedLine = this.processPlaceholders(player, line);
                builder.append(processedLine);
                continue;
            }
            builder.append((Component)Component.newline());
            processedLine = this.processPlaceholders(player, line);
            builder.append(processedLine);
        }
        return builder.build();
    }

    private Component processPlaceholders(Player player, String text) {
        String processed = text;
        processed = processed.replace("{player}", player.getName());
        processed = processed.replace("{world}", player.getWorld().getName());
        processed = processed.replace("{x}", String.valueOf(player.getLocation().getBlockX()));
        processed = processed.replace("{y}", String.valueOf(player.getLocation().getBlockY()));
        processed = processed.replace("{z}", String.valueOf(player.getLocation().getBlockZ()));
        processed = processed.replace("{server_name}", Bukkit.getServer().getName());
        processed = processed.replace("{online_players}", String.valueOf(Bukkit.getOnlinePlayers().size()));
        processed = processed.replace("{max_players}", String.valueOf(Bukkit.getMaxPlayers()));
        processed = processed.replace("{server_version}", Bukkit.getServer().getVersion());
        if (this.placeholder.equals("item")) {
            ItemStack item = player.getInventory().getItemInMainHand();
            processed = this.processItemPlaceholders(processed, item);
        } else if (this.placeholder.equals("ping")) {
            int ping = player.getPing();
            processed = processed.replace("{ping}", String.valueOf(ping));
            String quality = ping < 100 ? "Excellent" : (ping < 300 ? "Good" : "Poor");
            processed = processed.replace("{ping_quality}", quality);
        }
        double tps = 20.0;
        try {
            processed = processed.replace("{tps}", "20.0");
        }
        catch (Exception e) {
            processed = processed.replace("{tps}", "20.0");
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                processed = PlaceholderAPI.setPlaceholders((Player)player, (String)processed);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ColorUtil.parseComponent(processed);
    }

    private String processItemPlaceholders(String text, ItemStack item) {
        if (item == null || item.getType().isAir()) {
            text = text.replace("{item_name}", "Air");
            text = text.replace("{item_amount}", "0");
            text = text.replace("{item_lore}", "");
            text = text.replace("{item_enchantments}", "");
            text = text.replace("{item_durability}", "");
            return text;
        }
        String itemName = item.getItemMeta() != null && item.getItemMeta().hasDisplayName() ? item.getItemMeta().getDisplayName() : item.getType().name().replace("_", " ").toLowerCase();
        text = text.replace("{item_name}", itemName);
        text = text.replace("{item_amount}", String.valueOf(item.getAmount()));
        if (item.getItemMeta() != null && item.getItemMeta().hasLore()) {
            StringBuilder loreBuilder = new StringBuilder();
            for (String loreLine : item.getItemMeta().getLore()) {
                if (loreBuilder.length() > 0) {
                    loreBuilder.append("\n");
                }
                loreBuilder.append(loreLine);
            }
            text = text.replace("{item_lore}", loreBuilder.toString());
        } else {
            text = text.replace("{item_lore}", "");
        }
        if (item.getItemMeta() != null && item.getItemMeta().hasEnchants()) {
            StringBuilder enchantBuilder = new StringBuilder();
            for (Enchantment enchantment : item.getItemMeta().getEnchants().keySet()) {
                if (enchantBuilder.length() > 0) {
                    enchantBuilder.append(", ");
                }
                int level = item.getItemMeta().getEnchantLevel(enchantment);
                String enchantName = enchantment.getKey().getKey().replace("_", " ").toLowerCase();
                enchantBuilder.append(enchantName).append(" ").append(level);
            }
            text = text.replace("{item_enchantments}", enchantBuilder.toString());
        } else {
            text = text.replace("{item_enchantments}", "");
        }
        if (item.getType().getMaxDurability() > 0) {
            short maxDurability = item.getType().getMaxDurability();
            int currentDurability = maxDurability - (item.getDurability() & 0xFFFF);
            double percentage = (double)currentDurability / (double)maxDurability * 100.0;
            String durabilityText = currentDurability + "/" + maxDurability + " (" + String.format("%.1f", percentage) + "%)";
            text = text.replace("{item_durability}", durabilityText);
        } else {
            text = text.replace("{item_durability}", "");
        }
        return text;
    }

    private String processPlaceholdersAsString(Player player, String text) {
        String processed = text;
        processed = processed.replace("{player}", player.getName());
        processed = processed.replace("{world}", player.getWorld().getName());
        processed = processed.replace("{x}", String.valueOf(player.getLocation().getBlockX()));
        processed = processed.replace("{y}", String.valueOf(player.getLocation().getBlockY()));
        processed = processed.replace("{z}", String.valueOf(player.getLocation().getBlockZ()));
        processed = processed.replace("{server_name}", Bukkit.getServer().getName());
        processed = processed.replace("{online_players}", String.valueOf(Bukkit.getOnlinePlayers().size()));
        processed = processed.replace("{max_players}", String.valueOf(Bukkit.getMaxPlayers()));
        processed = processed.replace("{server_version}", Bukkit.getServer().getVersion());
        if (this.placeholder.equals("item")) {
            ItemStack item = player.getInventory().getItemInMainHand();
            processed = this.processItemPlaceholders(processed, item);
        } else if (this.placeholder.equals("ping")) {
            int ping = player.getPing();
            processed = processed.replace("{ping}", String.valueOf(ping));
            String quality = ping < 100 ? "Excellent" : (ping < 300 ? "Good" : "Poor");
            processed = processed.replace("{ping_quality}", quality);
        }
        double tps = 20.0;
        try {
            processed = processed.replace("{tps}", "20.0");
        }
        catch (Exception e) {
            processed = processed.replace("{tps}", "20.0");
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                processed = PlaceholderAPI.setPlaceholders((Player)player, (String)processed);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return processed;
    }

    private ClickEvent createClickEvent(Player player) {
        String value = this.clickAction.value;
        value = this.processPlaceholdersAsString(player, value);
        return switch (this.clickAction.type.toLowerCase()) {
            case "command" -> ClickEvent.runCommand((String)value);
            case "suggest_command" -> ClickEvent.suggestCommand((String)value);
            case "open_url" -> ClickEvent.openUrl((String)value);
            default -> null;
        };
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    @Override
    public void setPermission(String permission) {
        this.permission = permission != null ? permission : "";
    }

    private static class ClickAction {
        final String type;
        final String value;

        ClickAction(String type, String value) {
            this.type = type;
            this.value = value;
        }
    }
}

