/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.service;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.config.DeathConfig;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.core.DeathMessageManager;
import com.nonxedy.nonchat.core.IndirectDeathTracker;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import com.nonxedy.nonchat.util.core.debugging.Debugger;
import com.nonxedy.nonchat.util.death.DamageRecord;
import com.nonxedy.nonchat.util.death.DamageType;
import com.nonxedy.nonchat.util.death.DeathMessage;
import com.nonxedy.nonchat.util.integration.external.IntegrationUtil;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.projectiles.ProjectileSource;

public class DeathMessageService {
    private final Nonchat plugin;
    private final DeathMessageManager messageManager;
    private final DeathConfig deathConfig;
    private final Debugger debugger;
    private final IndirectDeathTracker indirectDeathTracker;

    public DeathMessageService(Nonchat plugin, DeathConfig deathConfig, PluginMessages messages, IndirectDeathTracker indirectDeathTracker, Debugger debugger) {
        this.plugin = plugin;
        this.deathConfig = deathConfig;
        this.debugger = debugger;
        this.messageManager = new DeathMessageManager(plugin.getDataFolder(), debugger, deathConfig);
        this.indirectDeathTracker = indirectDeathTracker;
        this.loadMessages();
    }

    public void handleDeath(PlayerDeathEvent event) {
        long startTime = System.currentTimeMillis();
        try {
            DeathMessageResult result = this.processDeathEvent(event);
            if (result == null) {
                return;
            }
            event.deathMessage(result.component);
            if (this.deathConfig.isDebugEnabled()) {
                String messageType = result.isIndirect ? "indirect" : "standard";
                this.debugger.info("DeathMessageService", "Death message for " + result.player.getName() + " (" + result.causeKey + ", " + messageType + "): " + result.formattedMessage);
            }
            long processingTime = System.currentTimeMillis() - startTime;
            if (this.deathConfig.isDebugEnabled()) {
                this.debugger.info("DeathMessageService", "Total death processing time for " + result.player.getName() + ": " + processingTime + "ms" + (result.isIndirect ? " (with indirect tracking)" : ""));
            }
            if (processingTime > 100L) {
                this.debugger.warn("DeathMessageService", "Death processing took " + processingTime + "ms for " + result.player.getName() + " (target: <100ms) - this may indicate performance issues");
            }
        }
        catch (Exception e) {
            this.debugger.error("DeathMessageService", "Error handling death: " + e.getMessage(), e);
        }
    }

    public Component getDeathMessage(PlayerDeathEvent event) {
        try {
            DeathMessageResult result = this.processDeathEvent(event);
            if (result == null) {
                return this.deathConfig.useFallback() ? null : Component.empty();
            }
            if (this.deathConfig.isDebugEnabled()) {
                this.debugger.info("DeathMessageService", "Death message for " + result.player.getName() + " (" + result.causeKey + "): " + result.formattedMessage);
            }
            return result.component;
        }
        catch (Exception e) {
            this.debugger.error("DeathMessageService", "Error processing death message: " + e.getMessage(), e);
            return null;
        }
    }

    private DeathMessageResult processDeathEvent(PlayerDeathEvent event) {
        if (!this.deathConfig.isEnabled()) {
            if (this.deathConfig.isDebugEnabled()) {
                this.debugger.info("DeathMessageService", "Death message system is disabled");
            }
            return null;
        }
        Player player = event.getEntity();
        String causeKey = this.extractDeathCauseKey(event);
        if (causeKey == null) {
            if (this.deathConfig.isDebugEnabled()) {
                this.debugger.info("DeathMessageService", "Could not determine death cause for player: " + player.getName());
            }
            return null;
        }
        Entity killer = this.extractKiller(event);
        boolean isEnvironmental = this.isEnvironmentalDeath(causeKey);
        if (isEnvironmental && killer instanceof Player) {
            if (this.deathConfig.isDebugEnabled()) {
                this.debugger.info("DeathMessageService", "Ignoring Bukkit's automatic killer assignment for environmental death (cause: " + causeKey + ")");
            }
            killer = null;
        }
        if (this.deathConfig.isDebugEnabled()) {
            this.debugger.info("DeathMessageService", "Death analysis for " + player.getName() + ":");
            this.debugger.info("DeathMessageService", "  - Cause: " + causeKey);
            this.debugger.info("DeathMessageService", "  - Killer: " + (killer != null ? killer.getType().name() : "null"));
            this.debugger.info("DeathMessageService", "  - Is environmental: " + isEnvironmental);
            this.debugger.info("DeathMessageService", "  - Tracking enabled: " + this.deathConfig.isIndirectTrackingEnabled());
        }
        boolean isIndirect = false;
        DamageType damageType = null;
        DamageRecord lastDamager = null;
        if (this.deathConfig.isIndirectTrackingEnabled() && killer == null && isEnvironmental) {
            lastDamager = this.indirectDeathTracker.getLastDamager(player);
            if (this.deathConfig.isDebugEnabled()) {
                this.debugger.info("DeathMessageService", "  - Checking for indirect death (lastDamager: " + (lastDamager != null ? "found" : "null") + ")");
            }
            if (lastDamager != null) {
                long trackingWindowMs = (long)this.deathConfig.getTrackingWindow() * 1000L;
                if (lastDamager.isValid(trackingWindowMs)) {
                    isIndirect = true;
                    damageType = lastDamager.getDamageType();
                    if (lastDamager.getDamagerUUID() != null) {
                        killer = Bukkit.getPlayer((UUID)lastDamager.getDamagerUUID());
                        if (killer == null && this.deathConfig.isDebugEnabled()) {
                            this.debugger.debug("DeathMessageService", "Indirect killer is offline: " + lastDamager.getDamagerName());
                        }
                    } else if (this.deathConfig.isDebugEnabled()) {
                        this.debugger.warn("DeathMessageService", "Damage record has null UUID for damager: " + lastDamager.getDamagerName());
                    }
                    if (this.deathConfig.isDebugEnabled()) {
                        this.debugger.info("DeathMessageService", "Indirect death detected for " + player.getName() + " - Killer: " + lastDamager.getDamagerName() + " - Damage Type: " + damageType.name() + " - Age: " + lastDamager.getAge() + "ms");
                    }
                } else if (this.deathConfig.isDebugEnabled()) {
                    this.debugger.info("DeathMessageService", "Damage record found for " + player.getName() + " but expired (age: " + lastDamager.getAge() + "ms, window: " + trackingWindowMs + "ms)");
                }
            } else if (this.deathConfig.isDebugEnabled()) {
                this.debugger.info("DeathMessageService", "No recent damager found for environmental death of " + player.getName() + " (cause: " + causeKey + ")");
            }
        } else if (this.deathConfig.isDebugEnabled()) {
            this.debugger.info("DeathMessageService", "  - Skipping indirect check: tracking=" + this.deathConfig.isIndirectTrackingEnabled() + ", killer==null=" + (killer == null) + ", isEnvironmental=" + this.isEnvironmentalDeath(causeKey));
        }
        if (!this.messageManager.hasCustomMessages(causeKey)) {
            if (this.deathConfig.isDebugEnabled()) {
                this.debugger.info("DeathMessageService", "No custom messages for death cause: " + causeKey);
            }
            return null;
        }
        DeathMessage deathMessage = this.messageManager.selectMessage(causeKey, isIndirect, damageType);
        if (deathMessage == null) {
            if (this.deathConfig.isDebugEnabled()) {
                this.debugger.info("DeathMessageService", "Failed to select message for cause: " + causeKey + " (indirect: " + isIndirect + ", damageType: " + String.valueOf(damageType) + ")");
            }
            return null;
        }
        String messageText = deathMessage.getMessage(isIndirect, damageType);
        String formattedMessage = this.formatDeathMessage(messageText, player, killer, lastDamager, event);
        formattedMessage = this.applyPlaceholderAPI(player, formattedMessage);
        Component finalComponent = ColorUtil.parseComponent(formattedMessage);
        return new DeathMessageResult(player, causeKey, isIndirect, formattedMessage, finalComponent);
    }

    private String extractDeathCauseKey(PlayerDeathEvent event) {
        try {
            EntityDamageEvent.DamageCause cause;
            EntityDamageEvent damageEvent = event.getEntity().getLastDamageCause();
            if (damageEvent != null && (cause = damageEvent.getCause()) != null) {
                return cause.name().toLowerCase();
            }
        }
        catch (Exception e) {
            this.debugger.warn("DeathMessageService", "Error extracting death cause: " + e.getMessage());
        }
        return null;
    }

    private boolean isEnvironmentalDeath(String causeKey) {
        String normalizedKey;
        if (causeKey == null || causeKey.isEmpty()) {
            return false;
        }
        List<String> trackedCauses = this.deathConfig.getTrackedCauses();
        return trackedCauses.contains(normalizedKey = causeKey.toLowerCase().replace('-', '_')) || trackedCauses.contains(causeKey.toUpperCase());
    }

    private Entity extractKiller(PlayerDeathEvent event) {
        try {
            Player victim = event.getEntity();
            if (victim == null) {
                return null;
            }
            Player playerKiller = victim.getKiller();
            if (playerKiller != null) {
                if (this.deathConfig.isDebugEnabled()) {
                    this.debugger.info("DeathMessageService", "Direct player killer found: " + playerKiller.getName());
                }
                return playerKiller;
            }
            EntityDamageEvent damageEvent = victim.getLastDamageCause();
            if (damageEvent instanceof EntityDamageByEntityEvent) {
                EntityDamageByEntityEvent entityDamageEvent = (EntityDamageByEntityEvent)damageEvent;
                Entity damager = entityDamageEvent.getDamager();
                if (this.deathConfig.isDebugEnabled()) {
                    this.debugger.info("DeathMessageService", "Damager entity found: " + (damager != null ? damager.getType().name() : "null"));
                }
                if (damager == null) {
                    if (this.deathConfig.isDebugEnabled()) {
                        this.debugger.debug("DeathMessageService", "Damager is null, treating as environmental death");
                    }
                    return null;
                }
                if (damager instanceof Projectile) {
                    Projectile projectile = (Projectile)damager;
                    ProjectileSource shooter = projectile.getShooter();
                    if (shooter == null) {
                        if (this.deathConfig.isDebugEnabled()) {
                            this.debugger.debug("DeathMessageService", "Projectile has null shooter (environmental)");
                        }
                        return null;
                    }
                    if (shooter instanceof Player) {
                        if (this.deathConfig.isDebugEnabled()) {
                            this.debugger.info("DeathMessageService", "Projectile shooter is player: " + ((Player)shooter).getName());
                        }
                        return (Player)shooter;
                    }
                    if (shooter instanceof Entity) {
                        if (this.deathConfig.isDebugEnabled()) {
                            this.debugger.info("DeathMessageService", "Projectile shooter is entity: " + ((Entity)shooter).getType().name());
                        }
                        return (Entity)shooter;
                    }
                    if (this.deathConfig.isDebugEnabled()) {
                        this.debugger.info("DeathMessageService", "Projectile has no valid shooter (environmental)");
                    }
                    return null;
                }
                if (damager instanceof TNTPrimed) {
                    TNTPrimed tnt = (TNTPrimed)damager;
                    Entity source = tnt.getSource();
                    if (source != null) {
                        if (this.deathConfig.isDebugEnabled()) {
                            this.debugger.info("DeathMessageService", "TNT source: " + source.getType().name());
                        }
                        return source;
                    }
                    if (this.deathConfig.isDebugEnabled()) {
                        this.debugger.info("DeathMessageService", "TNT has no source (environmental)");
                    }
                    return null;
                }
                if (this.deathConfig.isDebugEnabled() && damager != null) {
                    this.debugger.info("DeathMessageService", "Direct entity killer: " + damager.getType().name());
                }
                return damager;
            }
            if (this.deathConfig.isDebugEnabled()) {
                this.debugger.info("DeathMessageService", "No killer found for death event (environmental death)");
            }
        }
        catch (Exception e) {
            this.debugger.warn("DeathMessageService", "Error extracting killer: " + e.getMessage());
        }
        return null;
    }

    private String formatDeathMessage(String messageText, Player victim, Entity killer, DamageRecord lastDamager, PlayerDeathEvent event) {
        if (messageText == null) {
            return "";
        }
        String formatted = messageText;
        formatted = formatted.replace("%player_name%", victim.getName());
        formatted = formatted.replace("{victim}", victim.getName());
        formatted = formatted.replace("{player}", victim.getName());
        String killerName = this.deathConfig.getUnknownPlayerPlaceholder();
        if (killer instanceof Player) {
            killerName = ((Player)killer).getName();
        } else if (lastDamager != null) {
            killerName = lastDamager.getDamagerName();
        } else if (killer != null) {
            killerName = killer.getName();
        }
        formatted = formatted.replace("{killer_name}", killerName);
        formatted = formatted.replace("{killer}", killerName);
        formatted = formatted.replace("%killer_name%", killerName);
        if (this.deathConfig.showCoordinates()) {
            formatted = formatted.replace("{x}", String.valueOf(victim.getLocation().getBlockX()));
            formatted = formatted.replace("{y}", String.valueOf(victim.getLocation().getBlockY()));
            formatted = formatted.replace("{z}", String.valueOf(victim.getLocation().getBlockZ()));
            formatted = formatted.replace("{world}", victim.getWorld().getName());
        }
        return formatted;
    }

    private String applyPlaceholderAPI(Player player, String message) {
        if (!Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            if (this.deathConfig.isDebugEnabled()) {
                this.debugger.debug("DeathMessageService", "PlaceholderAPI not available, skipping placeholder processing");
            }
            return message;
        }
        try {
            return IntegrationUtil.processPlaceholders(player, message);
        }
        catch (Exception e) {
            this.debugger.warn("DeathMessageService", "Error processing PlaceholderAPI placeholders: " + e.getMessage());
            return message;
        }
    }

    private void loadMessages() {
        block3: {
            try {
                this.messageManager.loadMessages();
                if (this.debugger != null) {
                    this.debugger.info("DeathMessageService", "Death messages loaded successfully");
                }
            }
            catch (Exception e) {
                if (this.debugger == null) break block3;
                this.debugger.error("DeathMessageService", "Failed to load death messages: " + e.getMessage(), e);
            }
        }
    }

    public void reload() {
        Map<String, Integer> previousStats = null;
        boolean hadPreviousConfig = false;
        try {
            previousStats = this.getStatistics();
            boolean bl = hadPreviousConfig = !previousStats.isEmpty();
            if (this.indirectDeathTracker != null) {
                this.indirectDeathTracker.clearAll();
                if (this.deathConfig.isDebugEnabled()) {
                    this.debugger.info("DeathMessageService", "Cleared indirect death tracking data");
                }
            }
            this.deathConfig.reload();
            this.messageManager.loadMessages();
            Map<String, Integer> newStats = this.getStatistics();
            int totalMessages = newStats.values().stream().mapToInt(Integer::intValue).sum();
            int totalCauses = newStats.size();
            this.debugger.info("DeathMessageService", "Death messages reloaded successfully: " + totalMessages + " message variants across " + totalCauses + " death causes");
            if (this.deathConfig.isIndirectTrackingEnabled()) {
                this.debugger.info("DeathMessageService", "Indirect death tracking is enabled (window: " + this.deathConfig.getTrackingWindow() + "s, min damage: " + this.deathConfig.getMinimumDamage() + " hearts)");
                StringBuilder trackedTypes = new StringBuilder("Tracking damage types: ");
                if (this.deathConfig.isTrackMelee()) {
                    trackedTypes.append("melee ");
                }
                if (this.deathConfig.isTrackProjectile()) {
                    trackedTypes.append("projectile ");
                }
                if (this.deathConfig.isTrackExplosion()) {
                    trackedTypes.append("explosion");
                }
                this.debugger.info("DeathMessageService", trackedTypes.toString().trim());
                List<String> trackedCauses = this.deathConfig.getTrackedCauses();
                this.debugger.info("DeathMessageService", "Tracking " + trackedCauses.size() + " environmental death causes: " + String.join((CharSequence)", ", trackedCauses));
            } else {
                this.debugger.info("DeathMessageService", "Indirect death tracking is disabled");
            }
        }
        catch (Exception e) {
            this.debugger.error("DeathMessageService", "Failed to reload death messages: " + e.getMessage(), e);
            if (hadPreviousConfig && previousStats != null) {
                int previousTotal = previousStats.values().stream().mapToInt(Integer::intValue).sum();
                this.debugger.warn("DeathMessageService", "Maintaining previous configuration with " + previousTotal + " message variants");
            } else {
                this.debugger.warn("DeathMessageService", "No previous configuration available, death message system may be unavailable");
            }
            throw new RuntimeException("Failed to reload death messages", e);
        }
    }

    public Map<String, Integer> getStatistics() {
        return this.messageManager.getStatistics();
    }

    public Map<String, Object> getTrackingStatistics() {
        if (this.indirectDeathTracker == null) {
            return Map.of("error", "Indirect death tracker not initialized");
        }
        return this.indirectDeathTracker.getStatistics();
    }

    public void logTrackingStatistics() {
        if (!this.deathConfig.isIndirectTrackingEnabled()) {
            this.debugger.info("DeathMessageService", "[IndirectDeath] Tracking is disabled");
            return;
        }
        Map<String, Object> stats = this.getTrackingStatistics();
        DecimalFormat percentFormat = new DecimalFormat("0.00");
        String statsMessage = String.format("=== Indirect Death Tracking Statistics ===%nCache Size: %s entries%nHit Rate: %s%%%nMiss Rate: %s%%%nTotal Hits: %s%nTotal Misses: %s%nEvictions: %s%nConfiguration:%n  - Tracking Window: %s seconds%n  - Minimum Damage: %s hearts%n  - Track Melee: %s%n  - Track Projectile: %s%n  - Track Explosion: %s%n  - Tracked Causes: %s%n==========================================", stats.get("size"), percentFormat.format(((Number)stats.get("hitRate")).doubleValue() * 100.0), percentFormat.format(((Number)stats.get("missRate")).doubleValue() * 100.0), stats.get("hitCount"), stats.get("missCount"), stats.get("evictionCount"), this.deathConfig.getTrackingWindow(), this.deathConfig.getMinimumDamage(), this.deathConfig.isTrackMelee(), this.deathConfig.isTrackProjectile(), this.deathConfig.isTrackExplosion(), String.join((CharSequence)", ", this.deathConfig.getTrackedCauses()));
        this.debugger.info("DeathMessageService", statsMessage);
    }

    private static class DeathMessageResult {
        final Player player;
        final String causeKey;
        final boolean isIndirect;
        final String formattedMessage;
        final Component component;

        DeathMessageResult(Player player, String causeKey, boolean isIndirect, String formattedMessage, Component component) {
            this.player = player;
            this.causeKey = causeKey;
            this.isIndirect = isIndirect;
            this.formattedMessage = formattedMessage;
            this.component = component;
        }
    }
}

