/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.libs.caffeine.cache.Cache;
import com.nonxedy.nonchat.libs.caffeine.cache.Caffeine;
import com.nonxedy.nonchat.util.chat.filters.AdDetector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;

public class AsyncFilterService {
    private final ExecutorService filterExecutor;
    private final AdDetector adDetector;
    private final Nonchat plugin;
    private final Cache<String, Boolean> filterCache;

    public AsyncFilterService(Nonchat plugin, AdDetector adDetector) {
        this.plugin = plugin;
        this.adDetector = adDetector;
        this.filterCache = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
        this.filterExecutor = Executors.newCachedThreadPool(r -> {
            Thread thread = new Thread(r, "nonchat-filter-" + System.currentTimeMillis());
            thread.setDaemon(true);
            return thread;
        });
    }

    public CompletableFuture<Boolean> shouldFilterAsync(Player player, String message) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.adDetector.shouldFilter(player, message);
            }
            catch (Exception e) {
                this.plugin.logError("Error in async filter check for player " + player.getName() + ": " + e.getMessage());
                return false;
            }
        }, this.filterExecutor);
    }

    public void shutdown() {
        this.filterExecutor.shutdown();
    }
}

