/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.chat.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public class MessageHistory {
    private UUID playerUuid;
    private List<MessageEntry> messages;

    public MessageHistory(UUID playerUuid) {
        this.playerUuid = playerUuid;
        this.messages = new ArrayList<MessageEntry>();
    }

    public void addMessage(String message, long timestamp) {
        this.messages.add(new MessageEntry(message, timestamp));
    }

    public List<MessageEntry> getMessagesInTimeWindow(int timeWindowSeconds) {
        long currentTime = System.currentTimeMillis();
        long windowStart = currentTime - (long)timeWindowSeconds * 1000L;
        ArrayList<MessageEntry> result = new ArrayList<MessageEntry>();
        for (MessageEntry entry : this.messages) {
            if (entry.getTimestamp() < windowStart) continue;
            result.add(entry);
        }
        return result;
    }

    public void cleanupOldMessages(int maxTimeWindowSeconds) {
        long currentTime = System.currentTimeMillis();
        long cutoffTime = currentTime - (long)maxTimeWindowSeconds * 1000L;
        this.messages.removeIf(entry -> entry.getTimestamp() < cutoffTime);
    }

    public int getMessageCountInTimeWindow(int timeWindowSeconds) {
        return this.getMessagesInTimeWindow(timeWindowSeconds).size();
    }

    @Generated
    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    @Generated
    public List<MessageEntry> getMessages() {
        return this.messages;
    }

    @Generated
    public void setPlayerUuid(UUID playerUuid) {
        this.playerUuid = playerUuid;
    }

    @Generated
    public void setMessages(List<MessageEntry> messages) {
        this.messages = messages;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageHistory)) {
            return false;
        }
        MessageHistory other = (MessageHistory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$playerUuid = this.getPlayerUuid();
        UUID other$playerUuid = other.getPlayerUuid();
        if (this$playerUuid == null ? other$playerUuid != null : !((Object)this$playerUuid).equals(other$playerUuid)) {
            return false;
        }
        List<MessageEntry> this$messages = this.getMessages();
        List<MessageEntry> other$messages = other.getMessages();
        return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageHistory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $playerUuid = this.getPlayerUuid();
        result = result * 59 + ($playerUuid == null ? 43 : ((Object)$playerUuid).hashCode());
        List<MessageEntry> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MessageHistory(playerUuid=" + String.valueOf(this.getPlayerUuid()) + ", messages=" + String.valueOf(this.getMessages()) + ")";
    }

    @Generated
    public MessageHistory(UUID playerUuid, List<MessageEntry> messages) {
        this.playerUuid = playerUuid;
        this.messages = messages;
    }

    public static class MessageEntry {
        private String message;
        private long timestamp;

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageEntry)) {
                return false;
            }
            MessageEntry other = (MessageEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MessageEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MessageHistory.MessageEntry(message=" + this.getMessage() + ", timestamp=" + this.getTimestamp() + ")";
        }

        @Generated
        public MessageEntry(String message, long timestamp) {
            this.message = message;
            this.timestamp = timestamp;
        }
    }
}

