/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.chat.filters;

import com.nonxedy.nonchat.api.MessageFilter;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.libs.caffeine.cache.Cache;
import com.nonxedy.nonchat.libs.caffeine.cache.Caffeine;
import com.nonxedy.nonchat.util.chat.filters.MessageHistory;
import com.nonxedy.nonchat.util.chat.filters.TextSimilarityUtil;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpamDetector
implements MessageFilter {
    private final PluginConfig config;
    private final PluginMessages messages;
    private final Cache<UUID, MessageHistory> messageHistoryCache;

    public SpamDetector(PluginConfig config, PluginMessages messages) {
        this.config = config;
        this.messages = messages;
        int maxTimeWindow = Math.max(Math.max(config.getAntiSpamRepetitiveTimeWindow(), config.getAntiSpamSimilarTimeWindow()), config.getAntiSpamFloodTimeWindow());
        this.messageHistoryCache = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(maxTimeWindow + 60, TimeUnit.SECONDS).build();
    }

    @Override
    public boolean shouldFilter(Player player, String message) {
        if (!this.config.isAntiSpamEnabled()) {
            return false;
        }
        if (player.hasPermission("nonchat.spam.bypass")) {
            return false;
        }
        MessageHistory history = this.messageHistoryCache.get(player.getUniqueId(), uuid -> new MessageHistory((UUID)uuid));
        long currentTime = System.currentTimeMillis();
        if (this.config.isAntiSpamRepetitiveEnabled() && this.detectRepetitiveSpam(history, message)) {
            history.addMessage(message, currentTime);
            this.handleSpamDetection(player, message, "repetitive");
            return true;
        }
        if (this.config.isAntiSpamSimilarEnabled() && this.detectSimilarSpam(history, message)) {
            history.addMessage(message, currentTime);
            this.handleSpamDetection(player, message, "similar");
            return true;
        }
        if (this.config.isAntiSpamFloodEnabled() && this.detectFlood(history)) {
            history.addMessage(message, currentTime);
            this.handleSpamDetection(player, message, "flood");
            return true;
        }
        history.addMessage(message, currentTime);
        this.cleanupOldMessages(history);
        return false;
    }

    private boolean detectRepetitiveSpam(MessageHistory history, String message) {
        if (message == null) {
            return false;
        }
        int threshold = this.config.getAntiSpamRepetitiveThreshold();
        int timeWindow = this.config.getAntiSpamRepetitiveTimeWindow();
        List<MessageHistory.MessageEntry> recentMessages = history.getMessagesInTimeWindow(timeWindow);
        int count = 0;
        for (MessageHistory.MessageEntry entry : recentMessages) {
            if (entry == null || entry.getMessage() == null || !entry.getMessage().equals(message)) continue;
            ++count;
        }
        return count >= threshold;
    }

    private boolean detectSimilarSpam(MessageHistory history, String message) {
        if (message == null) {
            return false;
        }
        double threshold = this.config.getAntiSpamSimilarThreshold();
        int timeWindow = this.config.getAntiSpamSimilarTimeWindow();
        List<MessageHistory.MessageEntry> recentMessages = history.getMessagesInTimeWindow(timeWindow);
        for (MessageHistory.MessageEntry entry : recentMessages) {
            double similarity;
            if (entry == null || entry.getMessage() == null || entry.getMessage().equals(message) || !((similarity = TextSimilarityUtil.calculateSimilarity(message, entry.getMessage())) >= threshold)) continue;
            return true;
        }
        return false;
    }

    private boolean detectFlood(MessageHistory history) {
        int maxMessages = this.config.getAntiSpamFloodMaxMessages();
        int timeWindow = this.config.getAntiSpamFloodTimeWindow();
        int messageCount = history.getMessageCountInTimeWindow(timeWindow);
        return messageCount >= maxMessages;
    }

    private void handleSpamDetection(Player player, String message, String spamType) {
        List<String> actions = this.getActionsForSpamType(spamType);
        String warnMessage = this.getMessageForSpamType(spamType);
        for (String action : actions) {
            if (action.equalsIgnoreCase("block")) continue;
            if (action.equalsIgnoreCase("notify-staff")) {
                this.notifyStaff(player, message, spamType);
                continue;
            }
            this.executeCommand(player, action);
        }
        if (warnMessage != null && !warnMessage.isEmpty()) {
            String resolvedMessage = this.resolvePlaceholders(player, warnMessage);
            player.sendMessage(ColorUtil.parseComponentCached(resolvedMessage));
        }
    }

    private List<String> getActionsForSpamType(String spamType) {
        switch (spamType) {
            case "repetitive": {
                return this.config.getAntiSpamRepetitiveActions();
            }
            case "similar": {
                return this.config.getAntiSpamSimilarActions();
            }
            case "flood": {
                return this.config.getAntiSpamFloodActions();
            }
        }
        return List.of("block");
    }

    private String getMessageForSpamType(String spamType) {
        switch (spamType) {
            case "repetitive": {
                return this.config.getAntiSpamRepetitiveMessage();
            }
            case "similar": {
                return this.config.getAntiSpamSimilarMessage();
            }
            case "flood": {
                return this.config.getAntiSpamFloodMessage();
            }
        }
        return "";
    }

    private void notifyStaff(Player player, String message, String spamType) {
        if (player == null || spamType == null) {
            return;
        }
        String translationKey = "spam-detected-" + spamType;
        String notificationTemplate = this.messages.getString(translationKey);
        if (notificationTemplate == null || notificationTemplate.isEmpty()) {
            return;
        }
        String notification = notificationTemplate.replace("{player}", player.getName()).replace("{message}", message != null ? message : "[empty]");
        Component notificationComponent = ColorUtil.parseComponentCached(notification);
        Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission("nonchat.spam.notify") || p.isOp()).forEach(p -> p.sendMessage(notificationComponent));
        if (this.config.isAntiSpamConsoleNotifyEnabled()) {
            Bukkit.getConsoleSender().sendMessage(notificationComponent);
        }
    }

    private void executeCommand(Player player, String command) {
        if (command == null || command.isEmpty()) {
            return;
        }
        String resolvedCommand = this.resolvePlaceholders(player, command);
        try {
            Bukkit.getScheduler().runTask(Bukkit.getPluginManager().getPlugin("nonchat"), () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)resolvedCommand));
        }
        catch (IllegalArgumentException e) {
            Bukkit.getLogger().log(Level.WARNING, "\u00a7#FFAFFB[nonchat] \u00a7cFailed to execute spam action command: {0}", e.getMessage());
        }
    }

    private String resolvePlaceholders(Player player, String text) {
        if (player == null || text == null) {
            return text;
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return text.replace("%player_name%", player.getName()).replace("%player_uuid%", player.getUniqueId().toString());
    }

    private void cleanupOldMessages(MessageHistory history) {
        int maxTimeWindow = Math.max(Math.max(this.config.getAntiSpamRepetitiveTimeWindow(), this.config.getAntiSpamSimilarTimeWindow()), this.config.getAntiSpamFloodTimeWindow());
        history.cleanupOldMessages(maxTimeWindow);
    }
}

