/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.chat.filters;

public class TextSimilarityUtil {
    public static double calculateSimilarity(String str1, String str2) {
        String normalized2;
        if (str1 == null || str2 == null) {
            return 0.0;
        }
        String normalized1 = TextSimilarityUtil.normalizeString(str1);
        if (normalized1.equals(normalized2 = TextSimilarityUtil.normalizeString(str2))) {
            return 1.0;
        }
        int distance = TextSimilarityUtil.levenshteinDistance(normalized1, normalized2);
        int maxLength = Math.max(normalized1.length(), normalized2.length());
        if (maxLength == 0) {
            return 1.0;
        }
        return 1.0 - (double)distance / (double)maxLength;
    }

    private static String normalizeString(String str) {
        if (str == null) {
            return "";
        }
        return str.toLowerCase().trim();
    }

    private static int levenshteinDistance(String str1, String str2) {
        int i;
        int len1 = str1.length();
        int len2 = str2.length();
        int[][] dp = new int[len1 + 1][len2 + 1];
        for (i = 0; i <= len1; ++i) {
            dp[i][0] = i;
        }
        for (int j = 0; j <= len2; ++j) {
            dp[0][j] = j;
        }
        for (i = 1; i <= len1; ++i) {
            for (int j = 1; j <= len2; ++j) {
                dp[i][j] = str1.charAt(i - 1) == str2.charAt(j - 1) ? dp[i - 1][j - 1] : 1 + Math.min(Math.min(dp[i - 1][j], dp[i][j - 1]), dp[i - 1][j - 1]);
            }
        }
        return dp[len1][len2];
    }
}

