/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.core.broadcast;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.util.chat.filters.LinkDetector;
import com.nonxedy.nonchat.util.core.broadcast.BroadcastMessage;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class AutoBroadcastSender {
    private final Nonchat plugin;
    private final PluginConfig config;
    private final Map<String, BukkitTask> activeTasks;
    private final List<BroadcastMessage> randomMessagePool;
    private BukkitTask randomBroadcastTask;

    public AutoBroadcastSender(Nonchat plugin, PluginConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.activeTasks = new HashMap<String, BukkitTask>();
        this.randomMessagePool = new ArrayList<BroadcastMessage>();
    }

    public void start() {
        this.stop();
        Map<String, BroadcastMessage> configuredMessages = this.config.getBroadcastMessages();
        configuredMessages.forEach((key, message) -> {
            if (!message.isEnabled()) {
                return;
            }
            if (this.config.isRandomBroadcastEnabled()) {
                this.randomMessagePool.add((BroadcastMessage)message);
            } else {
                this.scheduleRegularBroadcast((String)key, (BroadcastMessage)message);
            }
        });
        if (this.config.isRandomBroadcastEnabled() && !this.randomMessagePool.isEmpty()) {
            this.startRandomBroadcasts();
        }
    }

    private void scheduleRegularBroadcast(String key, BroadcastMessage message) {
        BukkitTask task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.broadcastMessage(message.getMessage()), 0L, (long)message.getInterval() * 20L);
        this.activeTasks.put(key, task);
    }

    private void startRandomBroadcasts() {
        this.randomBroadcastTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            if (!this.randomMessagePool.isEmpty()) {
                BroadcastMessage message = this.randomMessagePool.get(new Random().nextInt(this.randomMessagePool.size()));
                this.broadcastMessage(message.getMessage());
            }
        }, 0L, 1200L);
    }

    private void broadcastMessage(String message) {
        Component broadcastMessage = ColorUtil.containsMiniMessageTags(message) ? ColorUtil.parseMiniMessageComponent(message) : LinkDetector.makeLinksClickable(message);
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(broadcastMessage);
        }
        this.plugin.getLogger().info(ColorUtil.stripAllColors(message));
    }

    public void stop() {
        this.activeTasks.values().forEach(BukkitTask::cancel);
        this.activeTasks.clear();
        if (this.randomBroadcastTask != null) {
            this.randomBroadcastTask.cancel();
            this.randomBroadcastTask = null;
        }
        this.randomMessagePool.clear();
    }
}

