/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.death;

import com.nonxedy.nonchat.util.death.DamageType;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class DeathMessage {
    private final String causeKey;
    private final String standardMessage;
    private final boolean enabled;
    private final Map<DamageType, String> indirectVariants;
    private final String genericIndirectMessage;

    public DeathMessage(String causeKey, String message, boolean enabled) {
        this.causeKey = causeKey;
        this.standardMessage = message;
        this.enabled = enabled;
        this.indirectVariants = new HashMap<DamageType, String>();
        this.genericIndirectMessage = null;
    }

    public DeathMessage(String causeKey, String standardMessage, boolean enabled, Map<DamageType, String> indirectVariants, String genericIndirectMessage) {
        this.causeKey = causeKey;
        this.standardMessage = standardMessage;
        this.enabled = enabled;
        this.indirectVariants = indirectVariants != null ? new HashMap<DamageType, String>(indirectVariants) : new HashMap();
        this.genericIndirectMessage = genericIndirectMessage;
    }

    public String getMessage(boolean isIndirect, DamageType damageType) {
        if (!isIndirect) {
            return this.standardMessage;
        }
        if (damageType != null && this.indirectVariants.containsKey((Object)damageType)) {
            return this.indirectVariants.get((Object)damageType);
        }
        if (this.genericIndirectMessage != null) {
            return this.genericIndirectMessage;
        }
        return this.standardMessage;
    }

    public boolean hasIndirectVariants() {
        return !this.indirectVariants.isEmpty() || this.genericIndirectMessage != null;
    }

    public boolean hasVariantForDamageType(DamageType damageType) {
        return damageType != null && this.indirectVariants.containsKey((Object)damageType);
    }

    @Generated
    public String getCauseKey() {
        return this.causeKey;
    }

    @Generated
    public String getStandardMessage() {
        return this.standardMessage;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public Map<DamageType, String> getIndirectVariants() {
        return this.indirectVariants;
    }

    @Generated
    public String getGenericIndirectMessage() {
        return this.genericIndirectMessage;
    }
}

