/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.lang;

import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageManager {
    private final File langsFolder;
    private FileConfiguration currentLang;
    private final Map<String, FileConfiguration> loadedLanguages;

    public LanguageManager(File dataFolder) {
        this.langsFolder = new File(dataFolder, "langs");
        this.loadedLanguages = new HashMap<String, FileConfiguration>();
        this.setupLanguages();
    }

    private void setupLanguages() {
        if (!this.langsFolder.exists()) {
            this.langsFolder.mkdirs();
        }
        this.createLanguageFile("messages_en.yml");
        this.createLanguageFile("messages_ru.yml");
        this.createLanguageFile("messages_es.yml");
        for (File file : this.langsFolder.listFiles()) {
            if (!file.getName().startsWith("messages_") || !file.getName().endsWith(".yml")) continue;
            String langCode = file.getName().replace("messages_", "").replace(".yml", "");
            this.loadedLanguages.put(langCode, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
        }
    }

    private void createLanguageFile(String filename) {
        File langFile = new File(this.langsFolder, filename);
        if (!langFile.exists()) {
            try (InputStream in = this.getClass().getResourceAsStream("/langs/" + filename);){
                Files.copy(in, langFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                Bukkit.getLogger().log(Level.WARNING, "Failed to create language file: {0}", e.getMessage());
            }
        }
    }

    public void setLanguage(String lang) {
        this.currentLang = this.loadedLanguages.getOrDefault(lang, this.loadedLanguages.get("en"));
    }

    public void reload() {
        this.loadedLanguages.clear();
        for (File file : this.langsFolder.listFiles()) {
            if (!file.getName().startsWith("messages_") || !file.getName().endsWith(".yml")) continue;
            String langCode = file.getName().replace("messages_", "").replace(".yml", "");
            this.loadedLanguages.put(langCode, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
        }
        if (this.currentLang != null) {
            String currentLangCode = null;
            for (Map.Entry<String, FileConfiguration> entry : this.loadedLanguages.entrySet()) {
                if (entry.getValue() != this.currentLang) continue;
                currentLangCode = entry.getKey();
                break;
            }
            if (currentLangCode != null) {
                this.setLanguage(currentLangCode);
            } else if (!this.loadedLanguages.isEmpty()) {
                this.setLanguage(this.loadedLanguages.containsKey("en") ? "en" : this.loadedLanguages.keySet().iterator().next());
            }
        }
    }

    public String getMessage(String key) {
        return ColorUtil.parseColor(this.currentLang.getString(key, "Missing message: " + key));
    }
}

