/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.command.impl;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.api.Channel;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.core.ChatManager;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ChannelCommand
implements CommandExecutor,
TabCompleter {
    private final ChatManager chatManager;
    private final PluginMessages messages;
    private final Nonchat plugin;

    public ChannelCommand(Nonchat plugin, ChatManager chatManager, PluginMessages messages) {
        this.plugin = plugin;
        this.chatManager = chatManager;
        this.messages = messages;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        this.plugin.logCommand(command.getName(), args);
        if (!(sender instanceof Player)) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("player-only")));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelp(player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "set": {
                return this.handleSetChannel(player, args);
            }
            case "list": {
                return this.handleListChannels(player);
            }
            case "info": {
                return this.handleChannelInfo(player, args);
            }
            case "create": {
                return this.handleCreateChannel(player, args);
            }
            case "delete": {
                return this.handleDeleteChannel(player, args);
            }
            case "edit": {
                return this.handleEditChannel(player, args);
            }
            case "default": {
                return this.handleSetDefaultChannel(player, args);
            }
        }
        this.sendHelp(player);
        return true;
    }

    private boolean handleSetChannel(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-set-usage")));
            return true;
        }
        String channelId = args[1].toLowerCase();
        Channel channel = this.chatManager.getChannel(channelId);
        if (channel == null) {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-not-found").replace("{channel}", channelId)));
            return true;
        }
        if (!channel.isEnabled()) {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-disabled").replace("{channel}", channel.getDisplayName())));
            return true;
        }
        if (!channel.canSend(player)) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
            return true;
        }
        if (this.chatManager.setPlayerChannel(player, channelId)) {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-set").replace("{channel}", channel.getDisplayName())));
        } else {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-set-failed").replace("{channel}", channelId)));
        }
        return true;
    }

    private boolean handleListChannels(Player player) {
        Collection<Channel> channels = this.chatManager.getEnabledChannels();
        Channel currentChannel = this.chatManager.getPlayerChannel(player);
        if (channels.isEmpty()) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-channels")));
            return true;
        }
        player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-list-header")));
        for (Channel channel : channels) {
            String entryMessage = this.messages.getString("channel-list-entry").replace("{id}", channel.getId()).replace("{display}", channel.getDisplayName()).replace("{current}", channel.getId().equals(currentChannel.getId()) ? this.messages.getString("channel-current") : "");
            if (channel.canSend(player)) {
                player.sendMessage(ColorUtil.parseComponent(entryMessage));
                continue;
            }
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-list-no-permission").replace("{id}", channel.getId()).replace("{display}", channel.getDisplayName())));
        }
        return true;
    }

    private boolean handleChannelInfo(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-info-usage")));
            return true;
        }
        String channelId = args[1].toLowerCase();
        Channel channel = this.chatManager.getChannel(channelId);
        if (channel == null) {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-not-found").replace("{channel}", channelId)));
            return true;
        }
        player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-info-header").replace("{channel}", channel.getDisplayName())));
        player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-info-id").replace("{id}", channel.getId())));
        player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-info-enabled").replace("{enabled}", channel.isEnabled() ? this.messages.getString("channel-info-yes") : this.messages.getString("channel-info-no"))));
        player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-info-character").replace("{character}", channel.hasTriggerCharacter() ? String.valueOf(channel.getCharacter()) : this.messages.getString("channel-info-none"))));
        player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-info-radius").replace("{radius}", channel.isGlobal() ? this.messages.getString("channel-info-global") : String.valueOf(channel.getRadius()))));
        return true;
    }

    private boolean handleCreateChannel(Player player, String[] args) {
        if (!player.hasPermission("nonchat.admin.channel.create")) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
            return true;
        }
        if (args.length < 3) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-create-usage")));
            return true;
        }
        String channelId = args[1].toLowerCase();
        String displayName = args[2];
        if (!channelId.matches("^[a-z0-9-]+$")) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-invalid-id")));
            return true;
        }
        if (this.chatManager.getChannel(channelId) != null) {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-already-exists").replace("{channel}", channelId)));
            return true;
        }
        String format = "\u00a77({display})\u00a7r {prefix} \u00a7f{sender}\u00a7r {suffix}\u00a77: \u00a7f{message}";
        format = format.replace("{display}", displayName);
        Character character = null;
        String sendPermission = "";
        String receivePermission = "";
        int radius = -1;
        int cooldown = 0;
        int minLength = 0;
        int maxLength = 256;
        int i = 3;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("format:")) {
                format = arg.substring(7);
            } else if (arg.startsWith("char:") && arg.length() > 5) {
                character = Character.valueOf(arg.charAt(5));
            } else if (arg.startsWith("send:")) {
                sendPermission = arg.substring(5);
            } else if (arg.startsWith("receive:")) {
                receivePermission = arg.substring(8);
            } else {
                if (arg.startsWith("radius:")) {
                    try {
                        radius = Integer.parseInt(arg.substring(7));
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("invalid-number")));
                        return true;
                    }
                }
                if (arg.startsWith("cooldown:")) {
                    try {
                        cooldown = Integer.parseInt(arg.substring(9));
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("invalid-number")));
                        return true;
                    }
                }
                if (arg.startsWith("min:")) {
                    try {
                        minLength = Integer.parseInt(arg.substring(4));
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("invalid-number")));
                        return true;
                    }
                }
                if (arg.startsWith("max:")) {
                    try {
                        maxLength = Integer.parseInt(arg.substring(4));
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("invalid-number")));
                        return true;
                    }
                }
            }
            ++i;
        }
        Channel channel = this.chatManager.createChannel(channelId, displayName, format, character, sendPermission, receivePermission, radius, cooldown, minLength, maxLength);
        if (channel == null) {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-create-failed").replace("{channel}", channelId)));
            return true;
        }
        player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-created").replace("{channel}", channel.getDisplayName())));
        return true;
    }

    private boolean handleEditChannel(Player player, String[] args) {
        if (!player.hasPermission("nonchat.admin.channel.edit")) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
            return true;
        }
        if (args.length < 3) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-edit-usage")));
            return true;
        }
        String channelId = args[1].toLowerCase();
        Channel channel = this.chatManager.getChannel(channelId);
        if (channel == null) {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-not-found").replace("{channel}", channelId)));
            return true;
        }
        String displayName = null;
        String format = null;
        Character character = null;
        String sendPermission = null;
        String receivePermission = null;
        Integer radius = null;
        Boolean enabled = null;
        Integer cooldown = null;
        Integer minLength = null;
        Integer maxLength = null;
        int i = 2;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("display:")) {
                displayName = arg.substring(8);
            } else if (arg.startsWith("format:")) {
                format = arg.substring(7);
            } else if (arg.startsWith("char:")) {
                character = arg.length() > 5 ? Character.valueOf(arg.charAt(5)) : Character.valueOf('\u0000');
            } else if (arg.startsWith("send:")) {
                sendPermission = arg.substring(5);
            } else if (arg.startsWith("receive:")) {
                receivePermission = arg.substring(8);
            } else {
                if (arg.startsWith("radius:")) {
                    try {
                        radius = Integer.valueOf(arg.substring(7));
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("invalid-number")));
                        return true;
                    }
                }
                if (arg.startsWith("enabled:")) {
                    enabled = arg.substring(8).equalsIgnoreCase("true");
                } else {
                    if (arg.startsWith("cooldown:")) {
                        try {
                            cooldown = Integer.valueOf(arg.substring(9));
                        }
                        catch (NumberFormatException e) {
                            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("invalid-number")));
                            return true;
                        }
                    }
                    if (arg.startsWith("min:")) {
                        try {
                            minLength = Integer.valueOf(arg.substring(4));
                        }
                        catch (NumberFormatException e) {
                            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("invalid-number")));
                            return true;
                        }
                    }
                    if (arg.startsWith("max:")) {
                        try {
                            maxLength = Integer.valueOf(arg.substring(4));
                        }
                        catch (NumberFormatException e) {
                            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("invalid-number")));
                            return true;
                        }
                    }
                }
            }
            ++i;
        }
        boolean success = this.chatManager.updateChannel(channelId, displayName, format, character, sendPermission, receivePermission, radius, enabled, cooldown, minLength, maxLength);
        if (success) {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-updated").replace("{channel}", channel.getDisplayName())));
        } else {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-update-failed").replace("{channel}", channelId)));
        }
        return true;
    }

    private boolean handleDeleteChannel(Player player, String[] args) {
        if (!player.hasPermission("nonchat.admin.channel.delete")) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
            return true;
        }
        if (args.length < 2) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-delete-usage")));
            return true;
        }
        String channelId = args[1].toLowerCase();
        Channel channel = this.chatManager.getChannel(channelId);
        if (channel == null) {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-not-found").replace("{channel}", channelId)));
            return true;
        }
        boolean success = this.chatManager.deleteChannel(channelId);
        if (success) {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-deleted").replace("{channel}", channel.getDisplayName())));
        } else {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-delete-failed").replace("{channel}", channel.getDisplayName())));
        }
        return true;
    }

    private boolean handleSetDefaultChannel(Player player, String[] args) {
        if (!player.hasPermission("nonchat.admin.channel.default")) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
            return true;
        }
        if (args.length < 2) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-default-usage")));
            return true;
        }
        String channelId = args[1].toLowerCase();
        Channel channel = this.chatManager.getChannel(channelId);
        if (channel == null) {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-not-found").replace("{channel}", channelId)));
            return true;
        }
        boolean success = this.chatManager.setDefaultChannel(channelId);
        if (success) {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-default-set").replace("{channel}", channel.getDisplayName())));
        } else {
            player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-default-failed").replace("{channel}", channel.getDisplayName())));
        }
        return true;
    }

    private void sendHelp(Player player) {
        player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-help-header")));
        player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-help-set")));
        player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-help-list")));
        player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-help-info")));
        if (player.hasPermission("nonchat.admin.channel.create")) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-help-create")));
        }
        if (player.hasPermission("nonchat.admin.channel.edit")) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-help-edit")));
        }
        if (player.hasPermission("nonchat.admin.channel.delete")) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-help-delete")));
        }
        if (player.hasPermission("nonchat.admin.channel.default")) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("channel-help-default")));
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            ArrayList<String> subcommands = new ArrayList<String>();
            subcommands.add("set");
            subcommands.add("list");
            subcommands.add("info");
            if (player.hasPermission("nonchat.admin.channel.create")) {
                subcommands.add("create");
            }
            if (player.hasPermission("nonchat.admin.channel.edit")) {
                subcommands.add("edit");
            }
            if (player.hasPermission("nonchat.admin.channel.delete")) {
                subcommands.add("delete");
            }
            if (player.hasPermission("nonchat.admin.channel.default")) {
                subcommands.add("default");
            }
            return this.filterStartingWith(args[0], subcommands);
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("info"))) {
            return this.filterStartingWith(args[1], this.chatManager.getAllChannels().stream().filter(Channel::isEnabled).filter(channel -> channel.canSend(player)).map(Channel::getId).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    private List<String> filterStartingWith(String prefix, List<String> options) {
        ArrayList<String> result = new ArrayList<String>();
        for (String option : options) {
            if (!option.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            result.add(option);
        }
        return result;
    }
}

