/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.command.impl;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class IgnoreCommand
implements CommandExecutor,
TabCompleter {
    private final Nonchat plugin;
    private final PluginMessages messages;
    private final Map<UUID, Set<UUID>> ignoredPlayers = new HashMap<UUID, Set<UUID>>();

    public IgnoreCommand(Nonchat plugin, PluginMessages messages) {
        this.plugin = plugin;
        this.messages = messages;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        UUID targetUUID;
        this.plugin.logCommand(command.getName(), args);
        if (!(sender instanceof Player)) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("player-only")));
            this.plugin.logError("Ignore command can only be used by players");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("nonchat.ignore")) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
            this.plugin.logError("No permission for ignore command");
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("invalid-usage-ignore")));
            this.plugin.logError("Invalid arguments for ignore command");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("player-not-found")));
            this.plugin.logError("Target player not found");
            return true;
        }
        if (target.equals(player)) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("cannot-ignore-self")));
            this.plugin.logError("Player tried to ignore themselves");
            return true;
        }
        Set ignored = this.ignoredPlayers.computeIfAbsent(player.getUniqueId(), k -> new HashSet());
        if (ignored.contains(targetUUID = target.getUniqueId())) {
            ignored.remove(targetUUID);
            sender.sendMessage(ColorUtil.parseComponent(this.messages.getString("unignored-player").replace("{player}", target.getName())));
            this.plugin.logResponse("Player unignored: " + target.getName());
        } else {
            ignored.add(targetUUID);
            sender.sendMessage(ColorUtil.parseComponent(this.messages.getString("ignored-player").replace("{player}", target.getName())));
            this.plugin.logResponse("Player ignored: " + target.getName());
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            String partialName = args[0].toLowerCase();
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(partialName)).filter(name -> !name.equals(sender.getName())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean isIgnoring(Player sender, Player target) {
        Set<UUID> ignored = this.ignoredPlayers.get(sender.getUniqueId());
        return ignored != null && ignored.contains(target.getUniqueId());
    }

    public Set<UUID> getIgnoredPlayers(Player player) {
        return this.ignoredPlayers.getOrDefault(player.getUniqueId(), new HashSet());
    }

    public boolean isIgnoringAnyone(Player player) {
        Set<UUID> ignored = this.ignoredPlayers.get(player.getUniqueId());
        return ignored != null && !ignored.isEmpty();
    }

    public void clearIgnoreList(Player player) {
        this.ignoredPlayers.remove(player.getUniqueId());
    }
}

