/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.command.impl;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.core.MessageManager;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ReplyCommand
implements CommandExecutor,
TabCompleter {
    private final Nonchat plugin;
    private final MessageManager messageManager;
    private final PluginMessages messages;

    public ReplyCommand(Nonchat plugin, MessageManager messageManager, PluginMessages messages) {
        this.plugin = plugin;
        this.messageManager = messageManager;
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        this.plugin.logCommand(command.getName(), args);
        if (!(sender instanceof Player)) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("player-only")));
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("nonchat.reply")) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
            if (this.plugin != null) {
                this.plugin.logError("Player " + sender.getName() + " tried to use the reply command without permission.");
            }
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("invalid-usage-reply")));
            return true;
        }
        this.messageManager.replyToLastMessage(player, String.join((CharSequence)" ", args));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("nonchat.reply")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            suggestions.add("message");
            return suggestions.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

